<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pagos extends Model
{
    use HasFactory;

    protected $table = 'pagos';
    protected $fillable = [
        'id',
        'cliente_id',
        'tipo_pago_id',
        'cuotas',
        'cuotas_restantes',
        'tiempo_pago',
        'monto_fraccionado',
        'monto_total',
        'monto_restante',
        'fecha_inicio',
        'fecha_pago',
        'fecha_final',
    ];

    public function scopeBuscarpor($query, $tipo ,$texto){
        if(($tipo) && ($texto)){
            return $query->where($tipo, 'like', "%$texto%");
        }
    }
}
