<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CustomerFormMailable extends Mailable
{
    use Queueable, SerializesModels;

    public $subject = 'Solicitud de manual';
    public $data;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $contents = 'https://ipssoma-storage.s3.eu-west-1.amazonaws.com/static/Manual_para_implementar_un_SGSST.pdf';
        return $this->from(env('MAIL_USERNAME'), 'Bienvenido a IPSSOMA')
                ->subject('Registro en IPSSOMA')
                ->view('emails.form_client')
                ->attach($contents);
    }
}
