<?php

namespace App\Http\Controllers\api;

use Carbon\Carbon;
use Dompdf\Dompdf;
use Dompdf\Options;
use App\Models\User;
use App\Models\Producto;
use App\Models\SSTClient;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Traits\ResponseFormat;
use App\Models\PurchasedProduct;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;

class SSTClientController extends Controller
{
    use ResponseFormat;

    public function getClientInfo(Request $request)
    {
        $client = SSTClient::where('doc_type_id', $request->doc_type_id)->where('num_doc', $request->num_doc)->exists();
        if ($client) {
            $client = SSTClient::where('doc_type_id', $request->doc_type_id)->where('num_doc', $request->num_doc)->get();
            $data = [];
            foreach ($client as $key => $item) {
                $data[$key]['id'] = $item->id;
                $data[$key]['title'] = $item->name_certificate;
                $data[$key]['path'] = 'https://ipssoma-storage.s3.eu-west-1.amazonaws.com/certificados/' . $item->filename;
            }
            return response()->json($data);
        } else {
            $data = [];
            return response()->json($data);
        }
    }

    public function downloadCertificate(Request $request)
    {
        $resource = SSTClient::findOrFail($request->id);

        if ($request->type === 'pdf') {
			
			$options = new Options();
			$options->set('orientation', 'landscape');
			$dompdf = new Dompdf($options);

			$imageUrl = Storage::disk('s3')->url('certificados/' . $resource->filename);
			$imageContent = file_get_contents($imageUrl);
			$pdfContent = view('pdf.image_to_pdf', ['imageContent' => $imageContent])->render();
			$dompdf->loadHtml($pdfContent);
			$dompdf->render();

			$headers = [
				'Content-Type' => 'application/pdf',
				'Content-Disposition' => 'attachment; filename="image_as_pdf.pdf"',
			];

			return response($dompdf->output(), Response::HTTP_OK, $headers);

        } elseif ($request->type === 'png') {
            $filePath = 'certificados/' . $resource->filename;
			return Storage::disk('s3')->download($filePath);
        } else {
            abort(Response::HTTP_BAD_REQUEST, 'Formato no válido');
        }
    }

    public function getCertificates(Request $request)
    {
        $user = User::findOrFail(auth()->user()->id);
        
 
        // $client = SSTClient::where('doc_type_id', $user->doc_type_id)->where('num_doc', $user->num_doc)->first();
        $client = SSTClient::where('doc_type_id', $user->doc_type_id)->where('num_doc', $user->number_doc)->first();
        
        if ($client) {
            $certificates = SSTClient::where('doc_type_id', $user->doc_type_id)
                // ->where('num_doc', $user->number_doc)
                ->where('num_doc', $user->number_doc)
                ->get();
            foreach ($certificates as $certificate) {
                $certificate->path = 'https://ipssoma-storage.s3.eu-west-1.amazonaws.com/certificados/' . $certificate->filename;
            }
        } else {
            $certificates = [];
        }
        return $certificates;
    }

    public function getFechas()
    {
        $current = Carbon::now();
        $fecha = PurchasedProduct::select('purchased_products.created_at','purchased_products.product_id')->join('product_payments', 'purchased_products.payment_id', '=', 'product_payments.id')
            ->where('product_payments.user_id', auth()->user()->id)
            ->get();

        foreach ($fecha as $valor) {
            $product = Producto::find($valor->product_id);
            $valor->name = $product->nombre;
            $valor->start = Carbon::parse($valor->created_at)->toDateString();
            $valor->end = Carbon::parse($valor->created_at)->addMonths($product->months)->toDateString();
            $valor->days = Carbon::parse($valor->created_at)->addMonths($product->months)->diff($current)->days;
        }
        return $fecha;
    }
}
