<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\PurchasedProduct;
use Illuminate\Http\Request;

class PurchasedProductController extends Controller
{
    public function saveTimeClass(Request $request){
        if($request->display_time != 0){
            $purchased = PurchasedProduct::join('product_payments', 'purchased_products.payment_id', '=', 'product_payments.id')
                ->where('product_payments.user_id', auth()->user()->id)
                ->where('purchased_products.product_id', $request->course_id)
                ->pluck('purchased_products.id');
            $purchased = PurchasedProduct::findOrFail($purchased[0]);
            if($purchased->classes_info == null){
                $aux = array(
                    $request->class_id => [
                        'time' => $request->display_time,
                    ]
                );
                $purchased->classes_info = $aux;
                $purchased->update();
            }else{
                $object = json_decode($purchased->classes_info, true);
                $object[$request->class_id] = array(
                    'time' => $request->display_time,
                );
                $purchased->classes_info = $object;
                $purchased->update();
            }
        }
        return $purchased;
    }

    public function getTime(Request $request){
        $purchased_info = PurchasedProduct::join('product_payments', 'purchased_products.payment_id', '=', 'product_payments.id')
            ->where('product_payments.user_id', auth()->user()->id)
            ->where('purchased_products.product_id', $request->courseId)
            ->pluck('purchased_products.classes_info');
        $class_time = json_decode($purchased_info[0], true);
        return $class_time[$request->classId];
    }
}
