<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\Clas;
use App\Models\Exam;
use App\Models\ExamQuestion;
use App\Models\Module;
use App\Models\Producto;
use App\Models\ProductPayment;
use App\Models\PurchasedProduct;
use App\Models\TipoProducto;
use Illuminate\Http\Request;
use App\Traits\ResponseFormat;
use App\Models\User;
use Carbon\Carbon;

class ProductoController extends Controller
{
    use ResponseFormat;
    public function detailsCourse($slug)
    {
        $course = Producto::where('productos.slug', $slug)
            ->join('tipo_productos',  'tipo_productos.id',  '=', 'productos.tipo_producto_id')
            ->join('course_categories',  'course_categories.id',  '=', 'productos.course_categories_id')
            ->select('productos.*', 'tipo_productos.producto as tipo', 'course_categories.name as categoria')
            ->get()->first();
        return response()->json($course);
    }

    public function list()
    {
        $courses = Producto::select('nombre', 'precio', 'id', 'slug', 'tipo_producto_id', 'portada_url', 'will_learn', 'descripcion', 'video_name', 'video_url')
            ->orderBy('id', 'asc')
            ->where('estado_publicacion',1)
            ->get();
        foreach ($courses as $course) {
            if (strpos($course->portada_url, 'http') === false) {
                $course->portada_url = "https://ipssoma-storage.s3.eu-west-1.amazonaws.com/" . $course->portada_url;
            }
            if ($course->video_url != null && strpos($course->video_url, 'http') === false) {
                $course->video_url = "https://ipssoma-storage.s3.eu-west-1.amazonaws.com/" . $course->video_url;
            }
        }
        return response()->json($courses);
    }

    public function listMarketplace($id)
    {
        $purchased_ids = PurchasedProduct::join('product_payments', 'purchased_products.payment_id', '=', 'product_payments.id')
            ->where('product_payments.user_id', auth()->user()->id)
            ->where('product_payments.status', 1)
            ->pluck('purchased_products.product_id');

        $courses = Producto::whereNotIn('id', $purchased_ids)
            ->where('estado_publicacion', 1)
            ->select('nombre', 'precio', 'id', 'slug', 'tipo_producto_id', 'portada_url', 'descripcion', 'will_learn', 'video_url')
            ->get();

        foreach ($courses as $course) {
            if (strpos($course->portada_url, 'http') === false) {
                $course->portada_url = "https://ipssoma-storage.s3.eu-west-1.amazonaws.com/" . $course->portada_url;
            }
            if ($course->video_url != null && strpos($course->video_url, 'http') === false) {
                $course->video_url = "https://ipssoma-storage.s3.eu-west-1.amazonaws.com/" . $course->video_url;
            }
        }
        return response()->json($courses);
    }

    public function getType($id)
    {
        $type = TipoProducto::findOrFail($id);
        return $this->responseOk('', $type);
    }

    public function show($slug)
    {
        // $curso = Producto::select('nombre')->find($slug);
        $product = Producto::select('slug', 'id', 'nombre')->where('slug', $slug)->get()->first();
        if ($product) {
            $modules = Module::select('id', 'name', 'id_courses')->where('id_courses', '=', $product->id)->get();
            $lesson = [];
            $modulesJson = [];

            foreach ($modules as $module) {
                $lesson = Clas::where([
                    'id_modules' => $module->id,
                    'public_status' => 0
                ])->orderBy('order', 'asc')
                    ->get();
                $modulesJson[] = [
                    'name'       => $module->name,
                    'lessons'    => $lesson
                ];
            }

            $courseJson = [
                'title'    => $product->nombre,
                'modules'   => $modulesJson
            ];

            return response()->json($courseJson);
        } else {
            return false;
        }
    }

    public function courseContent($slug)
    {
        // $curso = Producto::select('nombre')->find($slug);
        $product = Producto::select('slug', 'id', 'nombre','months')->where('slug', $slug)->get()->first();
        $purchased_exist = PurchasedProduct::join('product_payments', 'purchased_products.payment_id', '=', 'product_payments.id')
            ->where('purchased_products.product_id', $product->id)
            ->where('product_payments.user_id', auth()->user()->id)
            ->exists();
        
        if(PurchasedProduct::select('purchased_products.created_at')->join('product_payments', 'purchased_products.payment_id', '=', 'product_payments.id')
        ->where('purchased_products.product_id', $product->id)
        ->where('product_payments.user_id', auth()->user()->id)->exists()){
            $fecha = PurchasedProduct::select('purchased_products.created_at')->join('product_payments', 'purchased_products.payment_id', '=', 'product_payments.id')
            ->where('purchased_products.product_id', $product->id)
            ->where('product_payments.user_id', auth()->user()->id)
            ->first();
        }else{
            $fecha = new PurchasedProduct();
            $fecha->created_at = today();
        }
        $fechaParse = Carbon::parse($fecha->created_at);
        $current = Carbon::now();
        $fechaCompra = $fechaParse->addMonths($product->months);

        $fechaInicio =Carbon::parse($fecha->created_at)->toDateString();
        $daysUntil =  $fechaParse->diff($current)->days;
        $fechaVencimiento = $fechaCompra->toDateString();  

        if ($purchased_exist) {
            $classes_status = PurchasedProduct::join('product_payments', 'purchased_products.payment_id', '=', 'product_payments.id')
                ->where('purchased_products.product_id', $product->id)
                ->where('product_payments.user_id', auth()->user()->id)
                ->pluck('purchased_products.classes_info');
            $status = json_decode($classes_status[0], true);
        } else {
            $status = null;
        }

        if ($product) {
            $modules = Module::select('id', 'name', 'id_courses')->where('id_courses', '=', $product->id)->get();
            $lesson = [];
            $modulesJson = [];

            foreach ($modules as $module) {
                $lesson = Clas::where([
                    'id_modules' => $module->id,
                    'public_status' => 0
                ])->orderBy('order', 'asc')
                    ->get();
                foreach ($lesson as $item) {
                    if ($status != null) {
                        if (array_key_exists($item->id, $status)) {
                            $item->checkpoint = true;
                        } else {
                            $item->checkpoint = false;
                        }
                    } else {
                        $item->checkpoint = false;
                    }
                }
                $modulesJson[] = [
                    'name'       => $module->name,
                    'lessons'    => $lesson
                ];
            }



            $courseJson = [
                'title'    => $product->nombre,
                'daysUntil'    => $daysUntil,
                'fechaInicio'    => $fechaInicio,
                'fechaVencimiento'    => $fechaVencimiento,
                'modules'   => $modulesJson
            ];

            return response()->json($courseJson);
        } else {
            return false;
        }
    }

    //CARRUSEL CURSOS COMPRADOS

    public function purchasedProducts($user_id)
    {
        $now = Carbon::now();
        $products = PurchasedProduct::join('productos', 'purchased_products.product_id', '=', 'productos.id')
            ->join('product_payments', 'purchased_products.payment_id', '=', 'product_payments.id')
            ->where('product_payments.user_id', $user_id)
            ->select(
                'productos.id',
                'productos.nombre',
                'productos.precio',
                'productos.portada_url',
                'productos.slug as slug_product',
                'productos.tipo_producto_id',
                'purchased_products.is_blocked',
                'purchased_products.created_at',
                'productos.months',
            )
            ->get();
        foreach ($products as $product) {
        if (strpos($product->portada_url, 'http') === false) {
            $product->portada_url = "https://ipssoma-storage.s3.eu-west-1.amazonaws.com/" . $product->portada_url;
        }

        $product->isPurchased = 1;

        $fechaVencimiento = Carbon::parse($product->created_at)->addMonths($product->months);
        if($fechaVencimiento < $now){
            $product->is_blocked = 1;
            $product->fechaVencimiento = 1;
        }else{
            $product->fechaVencimiento = 0;
        }
    }
        return $products;
    }

    //CURSO SLUG
    public function courseSlug($id)
    {
        $products = Producto::join('modules', 'productos.id', '=', 'modules.id_courses')
            ->join('class', 'modules.id', '=', 'class.id_modules')
            ->select('class.slug as slug_class')
            ->where('productos.id', $id)
            ->get()
            ->first();
        return $products;
    }

    // Return exam with questions
    public function exam(Request $request)
    {
        $actual_exam = Exam::where('id', $request->exam_id)->first();
        $questions = ExamQuestion::where('exam_id', $actual_exam->id)->get();
        foreach ($questions as $question) {
            $question->options = json_decode($question->options, TRUE);
        }
        $exam = array(
            "exam" => $actual_exam,
            "questions" => $questions,
        );
        return $this->responseOk('', $exam);
    }

    public function getDescription($slug)
    {
        $description = Producto::where('slug', $slug)->select('descripcion')->first();
        return $description;
    }

    public function courseId(Request $request)
    {
        $exam = Exam::findOrFail($request->exam_id);
        if ($exam->course_id != null) {
            $course_id = $exam->course_id;
        } else if ($exam->module_id != null) {
            $course_id = Module::where('id', $exam->module_id)->pluck('id_courses');
            $course_id = $course_id[0];
        } else if ($exam->lesson_id != null) {
            $course_id = Clas::join('modules', 'class.id_modules', '=', 'modules.id')
                ->where('class.id', $exam->lesson_id)
                ->pluck('modules.id_courses');
            $course_id = $course_id[0];
        }
        return $course_id;
    }

    public function prueba()
    {
        $exam_id = 1;
        $actual_exam = Exam::where('id', $exam_id)->first();
        $questions = ExamQuestion::where('exam_id', $actual_exam->id)->get();
        foreach ($questions as $question) {
            $question->options = json_decode($question->options, TRUE);
        }
        $exam = array(
            "exam" => $actual_exam,
            "questions" => $questions
        );
        return $exam;
    }
    public function prueba2()
    {
        $exam_id = 1;
        $actual_exam = Exam::where('id', $exam_id)->first();
        $questions = ExamQuestion::where('exam_id', $actual_exam->id)->get();
        foreach ($questions as $question) {
            $question->options = json_decode($question->options, TRUE);
        }
        $questions = array(
            "questions" => $questions
        );
        return $questions;
    }

    public function prueba3()
    {
        $message = array(
            "message" => "hola mundo",
            "message2" => array(
                "other_message" => "con c#",
                "third_message" => "with unity"
            )
        );
        return $message;
    }

    public function prueba4()
    {
        $message = array(
            "message" => "hola mundo",
        );
        return $message;
    }
}
