<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Mail\PurchasedProductMailable;
use App\Mail\TransferMailable;
use App\Mail\TransferMailableAdmin;
use App\Mail\PurchasedProductMailableAdmin;
use App\Models\CourseInvitation;
use App\Models\Offer;
use App\Models\Producto;
use App\Models\ProductPayment;
use App\Models\PurchasedProduct;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ProductPaymentController extends Controller
{
    public function savePayment(Request $request)
    {
        $payment = new ProductPayment();
        $payment->user_id = $request->user_id;
        $payment->product_id = $request->product_id;
        $payment->amount = $request->amount / 100;
        $payment->reference_code = $request->reference_code;
        $payment->product_type = $request->product_type;
        $payment->status = 1;
        $payment->save();

        if ($request->is_offer) {
            $products = Offer::where('id', $request->product_id)->pluck('products');
            $products_id = json_decode($products[0], true);
            foreach ($products_id as $product) {
                $purchased = new PurchasedProduct();
                $purchased->payment_id = $payment->id;
                $purchased->product_id = $product;
                $purchased->save();
                self::courseInvitations($product, $request->user_id);
            }

            $product = Offer::where('id', $request->product_id)
                ->select('name as nombre', 'price as precio', 'portada_url')
                ->first();
        } else {
            $purchased = new PurchasedProduct();
            $purchased->payment_id = $payment->id;
            $purchased->product_id = $request->product_id;
            $purchased->save();
            self::courseInvitations($request->product_id, $request->user_id);
            $product = Producto::where('id', $request->product_id)
                ->select('nombre', 'precio', 'portada_url')
                ->first();
        }

        $user = User::where('id', $request->user_id)
            ->select('email', 'name')
            ->first();

        $path = $path = "https://ipssoma-storage.s3.eu-west-1.amazonaws.com/" . $product->portada_url;
        $data = (object) array(
            'product_name' => $product->nombre,
            'price' => $product->precio,
            'portada' => $path,
            'email' => $user->email,
            // 'email' => $user->email,
            'username' => $user->name,
            'date' => Carbon::now(),
        );

        $content = new PurchasedProductMailable($data);

        Mail::to($user->email)
            ->send($content);

        $content2 = new PurchasedProductMailableAdmin($data);

        Mail::to('2402gladyslujan@gmail.com')
            ->send($content2);
    }

    static public function courseInvitations($course_id, $user_id)
    {
        if (CourseInvitation::where('user_id', $user_id)->exists()) {
            $invitation = CourseInvitation::where('user_id', $user_id)->first();
            if ($invitation->course_id == $course_id) {
                $invitation->status = 1;
                $invitation->update();
            }
        }
    }

    public function saveTransferPayment(Request $request)
    {
        if (ProductPayment::where('reference_code', $request->reference_code)->exists()) {
            return "repeated";
        }
        $payment = new ProductPayment();
        $payment->user_id = $request->user_id;
        $payment->product_id = $request->product_id;
        $payment->amount = $request->amount;
        $payment->bank = $request->bank;
        $payment->reference_code = $request->reference_code;
        $payment->status = 0;
        $payment->product_type = $request->product_type;
        $payment->save();

        if ($request->is_offer) {
            $product = Offer::where('id', $request->product_id)
                ->select('name as nombre', 'price as precio', 'portada_url')
                ->first();
        } else {
            $product = Producto::where('id', $request->product_id)
                ->select('nombre', 'precio', 'portada_url')
                ->first();
        }

        $user = User::where('id', $request->user_id)
            ->select('email', 'name')
            ->first();

        $path = $path = "https://ipssoma-storage.s3.eu-west-1.amazonaws.com/" . $product->portada_url;
        $data = (object) array(
            'product_name' => $product->nombre,
            'price' => $product->precio,
            'operation' => $request->reference_code,
            'bank' => $request->bank,
            'portada' => $path,
            'email' => $user->email,
            'username' => $user->name,
            'date' => Carbon::now(),
        );

        $content = new TransferMailable($data);

        Mail::to($user->email)
            ->send($content);

        $content2 = new TransferMailableAdmin($data);

        Mail::to('2402gladyslujan@gmail.com')
            ->send($content2);

        return "ok";
    }
}
