<?php

namespace App\Http\Controllers\api;

use Illuminate\Http\Request;
use App\Models\Process;
use App\Http\Controllers\Controller;

class ProcessController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $processes = Process::all();
        return response()->json($processes);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $request->validate(['name' => 'required|string|max:160']);
        $process = Process::create(['name' => $request->input('name')]);
        return response()->json(['message' => 'Process created successfully', 'process' => $process], 201);
    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        //
        $process = Process::find($id);
        if (!$process) {
            return response()->json(['message' => 'Process not found'], 404);
        }
        return response()->json($process);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        //
        $request->validate([
            'name' => 'required|string|max:160',
        ]);

        $process = Process::find($id);

        if (!$process) {
            return response()->json(['message' => 'Process not found'], 404);
        }

        $process->update([
            'name' => $request->name,
        ]);

        return response()->json(['message' => 'Process updated successfully', 'process' => $process]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
        $process = Process::find($id);

        if (!$process) {
            return response()->json(['message' => 'Process not found'], 404);
        }

        $process->delete();

        return response()->json(['message' => 'Process deleted successfully']);
    }
}
