<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\Clas;
use App\Models\Exam;
use App\Models\ExamQuestion;
use App\Models\Module;
use App\Models\Producto;
use App\Models\UserExam;
use App\Models\UserExamHeader;
use App\Models\UserQuestionAnswer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;


class ExamController extends Controller
{
    public function getActiveExam(Request $request)
    {
        // $data_course = Producto::join('modules', 'productos.id', '=', 'modules.id_courses')
        //     ->join('class', 'modules.id', '=', 'class.id_modules')
        //     ->where('class.slug', 'like', $request->slug_class)
        //     ->select('productos.id as course_id', 'modules.id as module_id', 'class.id as class_id')
        //     ->first();
        // $course_ids = [$data_course->course_id, $data_course->module_id, $data_course->class_id];
        // $field_id = ['course_id', 'module_id', 'lesson_id'];
        // $exam_title = ['Examen general del curso', 'Examen del módulo', 'Examen de la clase'];
        // // $id_type = [1, 2, 3];
        // $user_id = auth()->user()->id;
        // $exams = array();
        // $i = 0;
        // foreach ($course_ids as $data) {
        //     $exam =  Exam::where([$field_id[$i] => $data, 'status' => 1])->first();
        //     $userisAble = $this->userIsAbleToDoExam($field_id[$i], $user_id);
        //     if($userisAble[1]){
        //         $aux = [$exam_title[$i], true, $exam];
        //         // $aux = array(
        //         //     "exam_type" => $exam_title[$i],
        //         //     "isAvailable" => true,
        //             // "exam_info" => $exam
        //         // );
        //     }else{
        //         $aux = [$exam_title[$i], false, $userisAble[0]];
        //         // $aux = array(
        //         //     "exam_type" => $exam_title[$i],
        //         //     "isAvailable" => false,
        //             // "exam_info" => $exam
        //         // );
        //     }   
        //     $exams[$i] = $aux;
        //     $i++;
        // } 
        // return $exams;

        $exam_type = $request->exam_type;
        // $id_type = $request->id_type;
        $slug_class = $request->slug_class;
        // $id_type = Clas::join('modules', 'class.id_modules', '=', 'modules.id')
        //     ->where('slug', 'like', $slug_class)
        //     ->pluck('modules.id_courses');
        $id_type = Clas::where('slug', $slug_class)->where('status', 1)->pluck('id');

        switch ($exam_type) {
            case "course":
                $field_id = 'course_id';
                break;
            case "module":
                $field_id = 'module_id';
                break;
            case "class":
                $field_id = 'lesson_id';
                break;
            default:
                echo "No se especificó el tipo de examen";
        }
        $exam =  Exam::where([$field_id => $id_type[0], 'status' => 1])->first();
        $user_id = auth()->user()->id;

        // la posicion [1] entrega un booleano true false, la posicion [0] entrega un mensaje
        if ($exam) {
            $userisAble = $this->userIsAbleToDoExam($exam->id, $user_id);
            if ($userisAble[1]) {
                return $exam->id;
            } else {
                return $userisAble[0];
            }
        } else {
            return 'No existe el examen';
        }
    }

    //ESTA FUNCION VA A RETORNAR UN ARRAY, EL PRIMER VALOR ES EL MENSAJE , EL SEGUNDO ES EL BOOLEANRO TRUE FALSE
    public function userIsAbleToDoExam($exam_id, $user_id)
    {

        $fact = array();
        # Aprobó el examen
        $user_exam_conditions = UserExamHeader::where(['exam_id' => $exam_id, 'user_id' => $user_id])->pluck('condition')->toArray();

        if (in_array("Approved", $user_exam_conditions)) {
            $msg = 'El usuario ya aprobó el examen';
            $bol = false;
            array_push($fact, $msg);
            array_push($fact, $bol);
            return $fact;
        }

        # Examen is Waiting
        // if (in_array("Waiting", $user_exam_conditions)) {
        //     $msg = 'examen en espera';
        //     $bol = false;
        //     array_push($fact, $msg);
        //     array_push($fact, $bol);
        //     return $fact;
        // }

        # Intentos del usuario 
        $trys = UserExamHeader::where(['exam_id' => $exam_id, 'user_id' => $user_id])->get()->count();

        if ($trys == 3) {
            $msg = 'limite de intentos alcanzado';
            $bol = false;
            array_push($fact, $msg);
            array_push($fact, $bol);
            return $fact;
        }

        $msg = 'ok';
        $bol = true;
        array_push($fact, $msg);
        array_push($fact, $bol);
        return $fact;
    }

    public function getAnswers(Request $request)
    {

        $user_id = auth()->user()->id;
        $id_exam = $request->id_exam;
        $course_id = $request->course_id;
        $user_answers = (array) $request->answers;
        $seconds_used = $request->seconds_used;
        $answers = ExamQuestion::select('points', 'options', 'correct', 'question_type_id')->where('exam_id', $id_exam)->get();
        $exam = Exam::find($id_exam);

        //crear nuevo registro de user_exams
        $userExam = new UserExam();
        $userExam->course_id = $course_id;
        $userExam->user_id = auth()->user()->id;
        $userExam->save();

        try {
            DB::beginTransaction();
            $header = new UserExamHeader();
            $header->productor_id = $exam->productor_id;
            $header->user_id = $user_id;
            $header->exam_id = $id_exam;
            $header->rate = 0;
            $header->condition = "Waiting";
            $header->status = false;
            $header->user_exam_id = $userExam->id;
            $header->save();
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
        // return $answers;
        $nota = $this->rateExam($user_answers, $answers, $header->id, $userExam->id);
        $hasOpenQuestions = $this->hasOpenQuestions($id_exam);

        // examen de pregunta abierta se espera a que el productor califique
        if ($hasOpenQuestions == true) {
            $response = 'Waiting';
        } else {
            $hasTimer = $this->hasTimer($id_exam); # counter?

            if ($hasTimer == true) {

                $type = $this->determineType($id_exam);
                $header = UserExamHeader::where('id', $header->id)->get()->first();
                $header->condition = $this->getExamCondition($header->exam_id, $nota);
                $header->status = 1; # make visible to user
                $header->rate = $nota;
                $header->update();
                $response = $this->saveUserExam($exam, $nota, $type, $course_id, $seconds_used, $userExam->id);
            } else {
                $type = $this->determineType($id_exam);
                $header = UserExamHeader::where('id', $header->id)->get()->first();
                $header->condition = $this->getExamCondition($header->exam_id, $nota);
                $header->rate = $nota;
                $header->status = 1; # make visible to user
                $header->update();
                // app(UserExamHeaderController::class)->badgeForPassingTheExam($header->user_id);
                // $points_option_id = ConfigurationController::getOptionId('points_exam_course');
                // $virtual_points_gained = UserConfiguration::select('value')->where(['configuration_id' => $points_option_id, 'user_id' => $user_id])->get()->first()->value;
                $response = array('rate' => $nota, 'points_gained' => 100);
            }
        }
        return $response;
    }

    public function getResults(Request $request)
    {
        $questions = ExamQuestion::where('exam_id', $request->examId)->get();
        foreach ($questions as $question) {
            $question->options = json_decode($question->options, TRUE);
        }
        $latest_attempt_id = UserExamHeader::where('user_id', $request->user()->id)->where('exam_id', $request->examId)->latest()->value('id');
        $approved=UserExamHeader::where('id',$latest_attempt_id)->value('condition')==='Approved';
        $user_answers = UserQuestionAnswer::where('user_exam_id', $latest_attempt_id)->pluck('options_selected');
        $result_detail = [];
        foreach ($questions as $index => $question) {
            $options = $question->options;
            $user_selected = $options[$user_answers[$index]];
            $answer = $options[$question->correct];
            $resultadoPregunta = array(
                'pregunta' => $question->title,
                'respuestaSeleccionada' => $user_selected,
                'respuestaCorrecta' => $answer
            );
            array_push($result_detail, $resultadoPregunta);
        }
        return ['result'=>$approved,'detail'=>$result_detail];
    }

    public function rateExam($user_answers, $answers, $header_id, $userExam)
    {
        $nota = 0;
        $notas = [];
        foreach ($user_answers as $index => $user_answer) {
            $user_option = ($user_answer);
            $question_config = $answers[$index];

            // $question_config = json_decode($question_config, TRUE);
            $nota = $this->evaluateAccordingDataType($user_option['option'], $question_config, $header_id, $userExam);
            array_push($notas, $nota);
        }
        return array_sum($notas);
    }

    public function evaluateAccordingDataType($user_options_selected, $question_config, $header_id, $userExam)
    {
        $data_type = $question_config->question_type_id;

        switch ($data_type) {
            case 1: # Seleccion Simple
                $rate_per_question = $this->rateSimpleSelectionQuestion($question_config, $user_options_selected, $header_id, $userExam);
                break;
            case 2: # Seleccion Multiple
                $rate_per_question = $this->rateMultipleOptionQuestion($question_config, $user_options_selected, $header_id, $userExam);
                break;
            case 3: # Seleccion Binaria
                $rate_per_question = $this->rateBooleanQuestion($question_config, $user_options_selected, $header_id, $userExam);
                break;
            case 4: # Pregunta de criterio abierto
                # Guardar la respuesta del usuario y tener en cuenta sus respuestas para mostrar un exámen

                $detail = new UserQuestionAnswer();
                $detail->user_exam_id = $header_id;
                $detail->points_gained = 0;
                $detail->options_selected = array('response' => $user_options_selected);
                $detail->save();
                $rate_per_question = 0;
                break;
            default:
                $rate_per_question = 'Error';
                break;
        }

        return $rate_per_question;
    }

    public function rateBooleanQuestion($question_config, $user_options_selected, $header_id, $userExam)
    {
        $index = $question_config->correct;
        if ($index == $user_options_selected) {
            $nota = $question_config->points;
        } else {
            $nota = 0;
        }
        $detail = new UserQuestionAnswer();
        $detail->user_exam_id = $header_id;
        $detail->points_gained = $nota;
        $detail->options_selected = strval($user_options_selected);
        $detail->save();
        return $nota;
    }

    public function rateSimpleSelectionQuestion($question_config, $user_options_selected, $header_id, $userExam)
    {
        $index = $question_config->correct;
        if ($index == $user_options_selected) {
            $nota = $question_config->points;
        } else {
            $nota = 0;
        }

        $detail = new UserQuestionAnswer();
        $detail->user_exam_id = $header_id;
        $detail->points_gained = $nota;
        $detail->options_selected = strval($user_options_selected);
        $detail->save();
        return $nota;
    }

    public function rateMultipleOptionQuestion($question_config, $user_options_selected, $header_id, $userExam)
    {
        $correct_options = explode(',', $question_config->correct);
        $correctAnswersCount = $this->correctAnswersCount($correct_options, $user_options_selected);
        $incorrectAnswersCount = $this->incorrectAnswersCount($question_config->options, $correct_options, $user_options_selected);
        $negative_points = $this->calculateNegativePoints($question_config, $incorrectAnswersCount);
        $positive_points = $this->calculatePositivePoints($question_config, $correctAnswersCount,  $correct_options);
        $final_rate = $positive_points - $negative_points;
        $user_options_selected = json_encode($user_options_selected);
        // evitar que la nota sea negativa
        if ($final_rate < 0) {
            $final_rate = 0;
        }
        $detail = new UserQuestionAnswer();
        $detail->user_exam_id = $header_id;
        $detail->points_gained = $final_rate;
        $detail->options_selected = $user_options_selected;
        $detail->save();

        return $final_rate;
    }

    public function correctAnswersCount($correct_options, $user_options_selected)
    {
        $count = count(array_intersect($correct_options, $user_options_selected));
        return $count;
    }

    public function incorrectAnswersCount($question_options, $correct_options, $user_options_selected)
    {
        $incorrect_options = $this->getIncorrectOptions($question_options, $correct_options);
        $count = count(array_intersect($incorrect_options, $user_options_selected));
        return $count;
    }

    public function calculatePointsPerIncorrectAnswer($question_config)
    {
        $question_config->options = json_decode($question_config->options, TRUE);
        $points_per_answer = $question_config->points / count($question_config->options);
        return $points_per_answer;
    }

    public function calculatePointsPerCorrectAnswer($question_config, $correct_options)
    {
        $points_per_answer = $question_config->points / count($correct_options);
        return $points_per_answer;
    }

    public function calculateNegativePoints($question_config, $incorrect_quantity_selected)
    {
        $point_per_incorrect_answer = $this->calculatePointsPerIncorrectAnswer($question_config);
        $points = $incorrect_quantity_selected * $point_per_incorrect_answer;
        return $points;
    }

    public function calculatePositivePoints($question_config, $correctAnswersCount,  $correct_options)
    {
        $points_per_correct_question = $this->calculatePointsPerCorrectAnswer($question_config, $correct_options);
        $points = $correctAnswersCount * $points_per_correct_question;
        return $points;
    }

    public function saveUserExam($exam, $nota, $type, $course_id, $seconds_used, $userExamId)
    {
        try {
            DB::beginTransaction();
            $userExam = UserExam::findOrFail($userExamId);
            // $userExam = new UserExam();
            // $userExam->course_id = $course_id;
            // $userExam->user_id = auth()->user()->id;
            $userExam->exam_type_id = $type;
            $userExam->exam_note = $nota;
            $userExam->update();
            return $this->saveclassroomPointDetail($exam, $nota, $type, $course_id, $seconds_used);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function saveclassroomPointDetail($exam, $nota, $type, $course_id, $seconds_used)
    {
        $user_id = auth()->user()->id;
        if ($nota >= $exam->min_passing_score) {
            // $productor_id = Producto::where('id', $course_id)->get()->first()->user_id;
            // $points_option_id = ConfigurationController::getOptionId('exam_timer');
            // $total_points = UserConfiguration::select('value')->where(['configuration_id' => $points_option_id, 'user_id' => $productor_id])->get()->first()->value;
            $total_time = $exam->time;
            $left_time = $total_time - $seconds_used;
            $virtual_points_gained = 0;
            // $percentage = $this->calculatePercentage($total_time, $left_time);
            // $virtual_points_gained = round($total_points * $percentage, 0);

            // # Save ranking
            // RankingUserExamController::store($exam->id, $user_id, $seconds_used, $virtual_points_gained);
            # find user id position in array
            // $rank = RankingUserExam::where('exam_id', $exam->id)->orderBy('points')->pluck('user_id')->toArray();
            // $position = array_search($user_id, array_keys($rank)) + 1;
            $status = 'Aprobado';
            $position = 0;
            // $this->updateUserVirtualPoints($course_id, $virtual_points_gained, $type);
        } else {
            $virtual_points_gained = 0;
            $status = 'Desaprobado';
            $position = 0;
        }
        return array("rate" => $nota, "message" => $status, "points" => $virtual_points_gained, 'rank' => $position);
    }

    public function getIncorrectOptions($options, $correct_options)
    {
        $options = json_decode($options, TRUE);
        $incorrect_index_options = [];
        foreach ($options as $index => $item) {
            if (!in_array($index, $correct_options)) {
                array_push($incorrect_index_options, $index);
            }
        }

        return $incorrect_index_options;
    }

    public function hasOpenQuestions($exam_id)
    {
        $questions_type = ExamQuestion::select('question_type_id')->where('exam_id', $exam_id)->get();
        $array = [];
        foreach ($questions_type as $question_type) {
            array_push($array, $question_type->question_type_id);
        }
        // define("OPEN_QUESTION", 4);
        $bool = in_array(4, $array);
        return $bool;
    }

    public function hasTimer($exam_id)
    {
        $time = Exam::select('time')->where('id', $exam_id)->get()->first()->time;
        $result = $time != null ? true : false;
        return $result;
    }

    public function determineType($exam_id)
    {
        $exam = Exam::find($exam_id);
        if ($exam->course_id != null) {
            $type = '1'; // course
        } elseif ($exam->module_id != null) {
            $type = '2'; // module
        } elseif ($exam->lesson_id != null) {
            $type = '3'; // lesson
        }
        return $type;
    }

    public function getExamCondition($exam_id, $user_rate)
    {
        $min_score = Exam::select('min_passing_score')->where('id', $exam_id)->get()->first()->min_passing_score;
        if ($user_rate >= $min_score) {
            $condition = "Approved";
        } else {
            $condition = "Disaproved";
        }
        return $condition;
    }

    public function routeBack(Request $request)
    {
        if ($request->data == "preview") {
            $course = Producto::join('modules', 'productos.id', '=', 'modules.id_courses')
                ->join('class', 'modules.id', '=', 'class.id_modules')
                ->where('class.slug', $request->slug)
                ->select('productos.slug as product_slug', 'class.slug as slug_class')
                ->first();
        } else {
            $course = Producto::join('modules', 'productos.id', '=', 'modules.id_courses')
                ->join('class', 'modules.id', '=', 'class.id_modules')
                ->where('class.slug', $request->slug)
                ->select('productos.slug as product_slug', 'productos.tipo_producto_id', 'class.slug as slug_class')
                ->first();
            $course->tipo_producto_id = $course->tipo_producto_id == 1 ? 'curso' : 'diplomado';
        }
        return $course;
    }

    public function examList(Request $request)
    {
        $classes = Module::join('class', 'modules.id', '=', 'class.id_modules')
            ->join('productos', 'modules.id_courses', '=', 'productos.id')
            ->where('productos.slug', $request->slug)
            ->where('class.status', 1)
            ->select('class.id as class_id', 'class.name', 'class.slug')
            ->get();
        $modules = Producto::join('modules', 'productos.id', '=', 'modules.id_courses')
            ->where('productos.slug', $request->slug)
            ->select('modules.id as module_id', 'modules.name', 'modules.name as slug')
            ->get();
        $course = Producto::where('slug', $request->slug)
            ->select('id as product_id', 'nombre', 'slug')
            ->first();
        $data = [];
        $counter_class = 0;
        $count_exist_exam = 0;
        $count_approved_exam = 0;
        foreach ($classes as $class) {
            Log::info($class);
            if (Exam::where(['lesson_id' => $class->class_id, 'status' => 1])->exists()) {
                $class->exist = true;
                $exam_id = Exam::where('lesson_id', $class->class_id)->pluck('id');
                $user_attempt = UserExamHeader::where(['exam_id' => $exam_id[0], 'user_id' => auth()->user()->id])->latest(); 
                
                if ($user_attempt->exists()) {
                   $class->approved = $user_attempt->first()->condition;

                    if ($user_attempt->where('condition', 'Approved')->exists()) {
                        $count_approved_exam++;
                    }
                   
                    
                }

                $class->exam_id = $exam_id[0];
                $counter_class++;
                $count_exist_exam++;
            } else {
                $class->exist = false;
                $class->approved = false;
            }
        }
        $counter_module = 0;
        foreach ($modules as $module) {
            if (Exam::where(['module_id' => $module->module_id, 'status' => 1])->exists()) {
                $module->exist = true;
                $exam_id = Exam::where('module_id', $module->module_id)->pluck('id');
                $user_attempt = UserExamHeader::where(['exam_id' => $exam_id[0], 'user_id' => auth()->user()->id]);
                if ($user_attempt->exists()) {
                    if ($user_attempt->where('condition', 'Approved')->exists()) {

                        $count_approved_exam++;
                    }
                    $module->approved = $user_attempt->value('condition');
                }
                $module->exam_id = $exam_id[0];
                $counter_module++;
                $count_exist_exam++;
            } else {
                $module->exist = false;
                $module->approved = false;
            }
        }
        if (Exam::where(['course_id' => $course->product_id, 'status' => 1])->exists()) {
            $course->exist = true;
            $exam_id = Exam::where('course_id', $course->product_id)->pluck('id');
            $user_attempt = UserExamHeader::where(['exam_id' => $exam_id[0], 'user_id' => auth()->user()->id]);
            if ($user_attempt->exists()) {
                if ($user_attempt->where('condition', 'Approved')->exists()) {

                    $count_approved_exam++;
                }
                $course->approved = $user_attempt->value('condition');
            }
            $course->exam_id = $exam_id[0];
            $counter_course = 1;
            $count_exist_exam++;
        } else {
            $course->exist = false;
            $course->approved = false;
            $counter_course = 0;
        }
        $exam_progress = $count_exist_exam == 0 ? "empty" : round(($count_approved_exam / $count_exist_exam) * 100);
        $data = [
            'exams_class' => $classes,
            'exams_module' => $modules,
            'exam_course' => $course,
            'counter_class' => $counter_class,
            'counter_module' => $counter_module,
            'counter_course' => $counter_course,
            'exam_progress' => $exam_progress
        ];
        return $data;
    }
}
