<?php

namespace App\Http\Controllers;

use App\Models\Exam;
use App\Models\ExamQuestion;
use App\Models\QuestionType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ExamQuestionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth')->except('');
    }

    public function list($exam_id)
    {
        $questions = ExamQuestion::where('exam_id', $exam_id)->get();
        echo json_encode($questions);
    }

    public function store(Request $request)
    {
        try {
            DB::beginTransaction();
            $question = new ExamQuestion();
            $question->exam_id = $request->exam_id;
            $question->title = $request->title;
            $question->points = 0;
            $question->type = ''; //delete this
            $question->question_type_id = 1; // simple selection is default
            $question->save();
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function edit($id)
    {
        $question = ExamQuestion::where('id', $id)->get()->first();
        $exam = Exam::where('id', $question->exam_id)->get()->first();
        $type = $this->determineType($exam->id);
        $question_types = QuestionType::all();
        return view('content.courses.exam.question.edit', compact('question', 'question_types', 'exam', 'type'));
    }

    public function determineType($exam_id)
    {
        $exam = Exam::find($exam_id);
        if ($exam->course_id != null) {
            $type = '1'; // course
        } elseif ($exam->module_id != null) {
            $type = '2'; // module
        } elseif ($exam->lesson_id != null) {
            $type = '3'; // lesson
        }
        return $type;
    }

    public function get($id)
    {
        $question = ExamQuestion::where('id', $id)->get()->first();
        echo json_encode($question);
    }

    public function optionsStore(Request $request)
    {
        try {
            DB::beginTransaction();
            $question = ExamQuestion::where('id', $request->exam_question_id)->get()->first();
            $question->title =  $request->title;
            $question->points =  $request->points;
            $question->question_type_id =  $request->exam_type;
            $aux = json_decode($request->options, true);
            $options = $this->buildArray($aux);
            $question->correct =  $this->correctAnswers($aux);
            $question->options = $options;
            $question->type = $request->exam_type;
            $question->update();
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function correctAnswers($options){
        $aux = [];
        foreach ($options as $key => $option) {
            if($option["answer"]){
                array_push($aux, $key);
            }
        }
        $aux = implode(",", $aux);
        return $aux;
    }

    // public function buildArray($item1, $item2, $item3, $item4, $item5)
    public function buildArray($options)
    {
        $items = [];
        foreach ($options as $option) {
            array_push($items, $option["option"]);
        }
        return $items;
    }

    public function delete($id)
    {
        //sub-admin
        $rol_id = auth()->user()->roles_id;
        if($rol_id != 6){
            try {
                DB::beginTransaction();
                $question = ExamQuestion::where('id', $id);
                $question->delete();
                DB::commit();
            } catch (\Throwable $th) {
                DB::rollBack();
                throw $th;
            }
        }
    }
}
