<?php

namespace App\Http\Controllers;

use App\Models\Event;
use App\Http\Requests\StoreEventRequest;
use App\Http\Requests\UpdateEventRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use App\Helpers\Helper;

class EventController extends Controller
{
    public function create(){
        return view('content.events.create');
    }

    public function list(){
        $events = Event::all();
        return $events;
    }

    public function store(Request $request){
        $event = new Event();
        $event->name = $request->name;
        $event->description = $request->description;
        $event->date = $request->date;
        $event->hour = $request->hour;
        $event->status = 0;
        if($request->hasFile('file')){
            $file = $request->file('file');
            $event_name = Helper::formatFilename($file->getClientOriginalName());
            $path = 'pub_images/';
            Storage::disk('s3')->put($path.$event_name, file_get_contents($file), 'public');
            $event->filename = $event_name;
            $event->path = $path.$event_name;
        }
        $event->save();
    }

    public function update(Request $request){
        $event = Event::findOrFail($request->id);
        $event->name = $request->name;
        $event->description = $request->description;
        $event->date = $request->date;
        $event->hour = $request->hour;
        if($request->hasFile('file')){
            $file = $request->file('file');
            $event_name = Helper::formatFilename($file->getClientOriginalName());
            $path = 'pub_images/';
            if(Storage::disk('s3')->has($path.$event_name)){
                Storage::disk('s3')->delete($path.$event_name);
            }
            Storage::disk('s3')->put($path.$event_name, file_get_contents($file), 'public');
            $event->filename = $event_name;
            $event->path = $path.$event_name;
        }
        $event->update();
    }

    public function changeStatus($id){
        $event = Event::findOrFail($id);
        if($event->status == 1){
            $event->status = 0;
            $message = "Se ha ocultado el evento";
        }else{
            $event->status = 1;
            $message = "El evento es visible para los usuarios";
        }
        $event->update();

        return $message;
    }
}
