<?php

namespace App\Http\Controllers;

use App\Models\CourseGame;
use App\Models\CourseGameDetail;
use App\Models\GameType;
use App\Models\Producto;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CourseGameController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth')->except('');
    }
    
    public function index($id)
    {
        $game_type = GameType::all();
        $course = Producto::find($id);

        return view('content.gamification.games.index', compact('course', 'game_type'));
    }

    public function list($id)
    {
        $games = CourseGame::select('course_games.*', 'game_types.name as game_type')->where('course_id', $id)->join('game_types', 'course_games.game_type_id', '=', 'game_types.id')->get();
        echo json_encode($games);
    }

    public function store(Request $request)
    {
        try {
            DB::beginTransaction();
            $course_game = new CourseGame();

            switch ($request->game_for) {
                case 'course':
                    $course_game->course_id = $request->course_id;
                    break;
                case 'module':
                    $course_game->module_id = $request->module_id;
                    break;
                case 'lesson':
                    $course_game->lesson_id = $request->lesson_id;
                    break;

                default:
                    return 'Error';
                    break;
            }

            $course_game->name = $request->name;
            $course_game->game_type_id = $request->game_type_id;
            $course_game->status = 0;
            $course_game->save();

            $course_game_detail = new CourseGameDetail();

            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function edit($game_id)
    {
    
        $game = CourseGame::where('id', $game_id)->get()->first();
        return $this->getViewResponse($game);
       
    }

    public function getViewResponse($game)
    {
            $view = $this->getGameView($game->game_type_id);
            return view($view, compact('game'));
    }

    public function getGameView($game_type)
    {
        switch ($game_type) {
                # Ahorcado
            case 1:
                $view = 'content.courses.game.editGame1';
                break;
                # Pares de cartas
            case 2:
                $view = 'content.courses.game.editGame2';
                break;
            default:
                $view = 'Error de datos';
                break;
        }
        return $view;
    }

}
