<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\UserRequest;
use App\Http\Requests\UserRequest2;
use App\Http\Requests\UserRequest3;
use App\Providers\RouteServiceProvider;
use App\Models\User;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Models\CourseInvitation;
use Illuminate\Support\Facades\Redirect;
use App\Mail\RegisterMailable;
use App\Mail\RegisterMailableAlone;
use App\Mail\RegisterMailableAloneAdmin;
use App\Models\FractionedPayment;
use App\Mail\RegisterMailableSeller;
use App\Models\Producto;
use App\Models\ProductPayment;
use App\Models\PurchasedProduct;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth')->except('create', 'mostrarCurso');
        $this->middleware('admin')->except('create', 'mostrarCurso');
        // $this->middleware('seller')->except('adminRegistraUsuario');


        // $this->middleware('auth');
        // $this->middleware('admin');

    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
            'phone' => ['required', 'string', 'max:15'],
            'type_doc' => ['required', 'string', 'max:255'],
            'number_doc' => ['required', 'string', 'max:20'],
            'country' => ['required', 'string', 'max:255'],
            'birthday' => ['required', 'string', 'max:20'],
            'permissions',
            'rol' => ['required', 'integer'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\User
     */
    protected function create(Request $request)
    {
        if (User::where('email', 'like', $request->email)->exists()) {
            return "email repeat";
        }
        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->phone = $request->phone;
        $user->doc_type_id = $request->doc_type_id;
        $user->number_doc = $request->number_doc;
        $user->country = "null";
        $user->birthday = today();
        $user->roles_id = 2;
        $user->seller_id = $request->seller_id;
        $user->save();

        $courseInvitation = CourseInvitation::create([
            'course_id' => $request->course_id,
            'user_id' => $user->id,
            'status' => 0,
        ]);

        $product_info = Producto::join('tipo_productos', 'productos.tipo_producto_id', '=', 'tipo_productos.id')
            ->select('productos.slug', 'tipo_productos.producto')
            ->where('productos.id', $request->course_id)
            ->first();

        $product = Producto::where('id',  $request->course_id)
            ->select('nombre', 'precio', 'portada_url')
            ->first();

        $seller = User::find($request->seller_id);

        //MAIL PARA EL USUARIO

        $data = (object) array('email' => $request->email, 'username' => $request->name, 'password' => $request->password, 'seller_name' => $seller->name, 'seller_phone' => $seller->phone);
        $content = new RegisterMailable($data);

        Mail::to($request->email)
            ->cc($request->email)
            ->bcc($request->email)
            ->send($content);

        //EMAIL PARA EL VENDEDOR

        $data2 = (object) array('product_name' => $product->nombre, 'username' => $request->name, 'email' => $request->email, 'phone' => $request->phone);
        $content2 = new RegisterMailableSeller($data2);

        Mail::to($seller->email)
            ->cc($seller->email)
            ->bcc($seller->email)
            ->send($content2);

        $data3 = (object) array('username' => $request->name, 'email' => $request->email);
        $content3 = new RegisterMailableAloneAdmin($data3);

        Mail::to('2402gladyslujan@gmail.com')
            ->cc($request->email)
            ->bcc($request->email)
            ->send($content3);

        $tipo_producto = $product_info->producto == 'Normal' ? 'curso' : ($product_info->producto == 'Diplomado' ? 'diplomado' : 'curso');
        $destination = 'course_intro';
        $data = [$user->email, $user->password, $destination, $tipo_producto, $product_info->slug];
        $data = json_encode($data);
        $data = urlencode($data);
        // return redirect()->away('https://vcr.promolider.org/buy-cursos/51');
        return $data;
        // return redirect()->away('http://127.0.0.1:8080/redirect/'.$data);
        /* aquí redireccionar al curso  return view('');*/
    }

    protected function createNoVendedor(UserRequest2 $request)
    {
        // if(isset($data['permissions'])){
        //     $permissions = implode(', ', $data['permissions']);
        // }else{
        //     $permissions = null;
        // }
        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->phone = $request->phone;
        $user->doc_type_id = $request->type_doc;
        $user->number_doc = $request->number_doc;
        $user->country = $request->country;
        $user->birthday = $request->birthday;
        $user->roles_id = 2;
        $user->seller_id = $request->seller_id;
        $user->save();


        return redirect()->route('register.index');
    }

    protected function mostrarCurso($id)
    {
        $course = Producto::find($id);
        return $course;
    }

    protected function adminRegistraUsuario(Request $request)
    {
        try {
            DB::beginTransaction();

            $seller_id = auth()->user()->id;
            $user = new User();
            $user->name = $request->name;
            $user->email = $request->email;
            $user->password = Hash::make($request->password);
            $user->phone = $request->phone;
            $user->doc_type_id = $request->type_doc;
            $user->number_doc = $request->number_doc;
            $user->country = "null";
            $user->birthday = today();
            $user->roles_id = 2;
            $user->seller_id = $seller_id;
            $user->save();

            $data = (object) array('email' => $request->email, 'username' => $request->name, 'password' => $request->password);
            $content = new RegisterMailableAlone($data);

            Mail::to($request->email)
                ->cc($request->email)
                ->bcc($request->email)
                ->send($content);

            $data2 = (object) array('username' => $request->name, 'email' => $request->email);
            $content2 = new RegisterMailableAloneAdmin($data2);

            Mail::to('2402gladyslujan@gmail.com')
                ->cc($request->email)
                ->bcc($request->email)
                ->send($content2);

            $product_type = Producto::where('id', $request->producto_id)->pluck('tipo_producto_id');
            $payment = new ProductPayment();
            $payment->user_id = $user->id;
            $payment->amount = $request->amount;
            $payment->reference_code = "pago interno";
            $payment->bank = "pago interno";
            $payment->status = 1;
            $payment->product_type = $product_type[0];
            $payment->is_fractioned = $request->is_fractioned == "on" ? 1 : 0;
            if ($request->is_fractioned == "on") {
                $payment->is_fractioned = 1;
                $payment->pay_completed = 0;
            } else {
                $payment->is_fractioned = 0;
                $payment->pay_completed = 1;
            }
            $payment->product_id = $request->producto_id;
            $payment->save();

            if ($request->is_fractioned != null) {
                $fractioned = new FractionedPayment();
                $fractioned->payment_id = $payment->id;
                $fractioned->amount = $request->amount;
                $fractioned->fecha_pago = $request->fecha_pago;
                $fractioned->reference_code = "pago interno";
                $fractioned->bank = "pago interno";
                $fractioned->status = 1;
                $fractioned->save();
            }

            $purchased = new PurchasedProduct();
            $purchased->payment_id = $payment->id;
            $purchased->product_id = $request->producto_id;
            $purchased->save();

            $invitation = new CourseInvitation();
            $invitation->user_id = $user->id;
            $invitation->course_id = $request->producto_id;
            $invitation->status = 1;
            $invitation->save();


            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
}
