<?php

use App\Http\Controllers\Exam;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuxController;
use App\Http\Controllers\DailyQuestion;
use App\Http\Controllers\PayController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\BadgeController;
use App\Http\Controllers\BonusController;
use App\Http\Controllers\VideoController;
use App\Http\Controllers\OptionController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ReportsController;
use App\Http\Controllers\Api\CartController;
use App\Http\Controllers\Api\GameController;
use App\Http\Controllers\CommentsController;
use App\Http\Controllers\Api\SalesController;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\Api\CourseController;
use App\Http\Controllers\Api\LessonController;
use App\Http\Controllers\CourseGameController;
use App\Http\Controllers\CourseGameCommentController;
use App\Http\Controllers\Api\MessageController;
use App\Http\Controllers\ModuleClassController;
use App\Http\Controllers\RamaBinariaController;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\CertificatesController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\ClassResourceController;
use App\Http\Controllers\PaymentMethodController;
use App\Http\Controllers\MC\ParticipantController;
use App\Http\Controllers\Api\AccountTypeController;
use App\Http\Controllers\Api\CertificateController;
use App\Http\Controllers\Api\PreferencesController;
use App\Http\Controllers\FrequentQuestionsController;
use App\Http\Controllers\MC\InvitationLinkController;
use App\Http\Controllers\UnverifiedPaymentController;
use App\Http\Controllers\UserClassroomPointController;
use App\Http\Controllers\Api\PruebasApiJuegoController;
use App\Http\Controllers\CourseConfigurationController;
use App\Http\Controllers\Api\PurchasedCoursesController;
use App\Http\Controllers\ClassroomPointDetailController;
use App\Http\Controllers\Api\ApiWalletMovementsController;
use App\Http\Controllers\Api\PropiertiesforUserController;
use App\Http\Controllers\Api\UserController as ApiUserController;
use App\Http\Controllers\MC\VideoController as MCVideoController;
use App\Http\Controllers\CourseController as ControllersCourseController;
use App\Http\Controllers\MC\NotificationController as MCNotificationController;

//Post Store User
Route::group(['prefix' => '/v1'], function () {
    Route::group(['prefix' => 'auth', 'namespace' => 'Auth'], function () {
        // Route::post('/register', [AuthController::class, 'store']);
    });
});
Route::post('/register', [UserController::class, 'store']);

Route::group(['prefix' => '/v1'], function () {
    Route::group(['prefix' => '/public'], function(){
        Route::post('/sendRecoveryEmail', [UserController::class, 'sendRecoveryEmail'])->name('sendRecoveryEmail');
        Route::post('/recoveryPassword', [UserController::class, 'recoveryPassword'])->name('recoveryPassword');
    });
    if (config('app.is_api')) {
        Route::get('/listDocumentType', [ApiUserController::class, 'listDocumentType'])->name('document.list');
        Route::group(['prefix' => 'auth', 'namespace' => 'Auth'], function () {
            Route::post('login', [AuthController::class, 'login'])->name('auth.login');
            Route::post('redirect', [AuthController::class, 'loginApiForRedirect'])->name('auth.loginRedirect');
            Route::post('logout', [AuthController::class, 'logout'])->name('auth.logout')->middleware('auth:api');
        });

        // =================== Rutas para proyecto Juegos ===================

        Route::group(['prefix' => '/games-test'], function () {
            Route::get('/', [PruebasApiJuegoController::class, 'list']);
        });




        Route::middleware(['auth:api', 'checkAuth'])->group(function () {

            // =================== Rutas para proyecto Master Class ===================
            Route::group(['prefix' => 'mc'], function () {
                
                Route::get('notifications', [MCNotificationController::class, 'list']);
                Route::put('notifications/{id}', [MCNotificationController::class, 'markAsSeen']);
                Route::get('indicators', [MCVideoController::class, 'indicators']);
                Route::post('store', [MCVideoController::class, 'store']);
                Route::get('list', [MCVideoController::class, 'list']);
                Route::get('upcoming', [MCVideoController::class, 'upcoming'])->name('mc.upcoming');
                Route::post('filter', [MCVideoController::class, 'filter'])->name('mc.filter');
                Route::delete('delete/{id}', [MCVideoController::class, 'delete']);

                Route::post('show', [MCVideoController::class, 'show']);

                Route::group(['prefix' => 'course'], function () {
                    Route::get('list', [CourseController::class, 'listCourses']);
                });

                Route::group(['prefix' => 'participant'], function () {
                    Route::post('subscribe', [ParticipantController::class, 'subscribe']);
                    Route::get('list', [ParticipantController::class, 'list']);
                });
            });


            //Api User
            Route::group(['prefix' => '/user'], function () {
                Route::post('/update', [UserController::class, 'update']);
                Route::post('/update-user', [UserController::class, 'updateUser']);
                Route::get('/show', [UserController::class, 'show']);
                Route::post('/verify-duplicate', [UserController::class, 'verifyDuplicate']);
                Route::get('/get-rolename', [UserController::class, 'getRolename']);
                Route::post('/verify-unique-email', [UserController::class, 'verifyUniqueEmail']);
                Route::get('get-data-currentuser', [UserController::class, 'getDataCurrentUser']);
            });

            //Api Account Type
            Route::group(['prefix' => '/accout-type'], function () {
                Route::get('/{id}', [AccountTypeController::class, 'getDataBytId']);
            });

            //Api Message
            Route::group(['prefix' => '/messages'], function () {
                Route::get('/with/{email}', [MessageController::class, 'show']);
                Route::get('list', [MessageController::class, 'list']);
                Route::post('/add', [MessageController::class, 'addMessage']);
                Route::get('listAll', [MessageController::class, 'listAll']);

                Route::get('/listContacts/{id}', [MessageController::class, 'listContacts']);
                Route::get('/listNewContacts/{id}', [MessageController::class, 'listNewContacts']);
                Route::post('/sendNewMessage', [MessageController::class, 'sendNewMessage']);
                Route::post('/content', [MessageController::class, 'getContent']);
            });
            //Api category
            Route::group(['prefix' => 'category'], function () {
                Route::get('/list', [CategoryController::class, 'list']);
            });
            //Api references
            Route::group(['prefix' => 'preferences'], function () {
                Route::post('/add', [PreferencesController::class, 'store']);
                Route::post('/update/{id}', [PreferencesController::class, 'updatePreference']);
                Route::post('/delete-preferences', [PreferencesController::class, 'deleteUserPreferences']);
                Route::post('/delete/{id}', [PreferencesController::class, 'deletePreference']);
                Route::get('/show-preferences', [PreferencesController::class, 'myPreferences']);
            });

            Route::group(['prefix' => '/pay'], function(){
                Route::post('/course-openpay', [PayController::class, 'openpayCourse']);
                Route::post('/openpay-order', [OptionController::class, 'openpayOrder']);
                Route::post('/unverified-payment/create', [UnverifiedPaymentController::class, 'create']);
                Route::get('/get-openpay-conditions', [PaymentController::class, 'getOpenpayConditions']);
            });

            // Metodos de pago
            Route::group(['prefix' => '/config/payment-method'], function () {
                Route::get('/list-array', [PaymentMethodController::class, 'listPaymentMethods'])->name('payment-method-list-array');
            });

            // Monto Billetera
            Route::group(['prefix' => '/reports'], function () {
                Route::get('/mymovements/{user_id}', [ApiWalletMovementsController::class, 'getAllMovementsWallet']);
            });

            //Api Course
            Route::group(['prefix' => '/course'], function () {

                Route::get('/test/{id}', [ControllersCourseController::class, 'approved']);
                Route::get('/list', [CourseController::class, 'list']);
                Route::get('/list/random', [CourseController::class, 'listRandom']);
                Route::get('/temary/get-all-class/{id}', [CourseController::class, 'show']);
                Route::get('/producter/{id}', [CourseController::class, 'listProducer']);
                Route::get('/details/{id}', [CourseController::class, 'detailsCourse']);
                Route::get('/recomendations/{category}', [CourseController::class, 'recomendations']);
                Route::get('/add/lesson/{id}', [CourseController::class, 'addLatestLesson']);
                Route::get('/show/lesson', [CourseController::class, 'showLatestLesson']);
                Route::get('/related-courses', [CourseController::class, 'recommendedCourses']);
                Route::get('/interesting-courses', [CourseController::class, 'interestingCourses']);
                Route::get('/released-courses', [CourseController::class, 'releasedCourses']);
                Route::get('/last-courses-rep', [CourseController::class, 'lastCoursesReprod']);
                
                Route::get('/purchased-courses', [CourseController::class, 'purchasedCourses']);
                Route::post('/buy-purchased-course', [CourseController::class, 'setPurshaseCouse']);
                Route::get('/search-courses/{str}', [CourseController::class, 'searchCourses']);

                Route::get('/certificate-list', [CertificatesController::class, 'getCertificateUserList']);
                Route::get('/certificate-discount', [AccountTypeController::class, 'certificateDiscount']);
                Route::get('/course-discount', [AccountTypeController::class, 'courseDiscount']);

                Route::get('/rate/show/{id}', [CourseController::class, 'rateCourseShow']);
                Route::post('/rate/store', [CourseController::class, 'rateCourseStore']);
                Route::get('/list-actives/producer', [CourseController::class, 'listActiveCourses']);
                Route::get('/certificate/data', [CourseConfigurationController::class, 'getCertificateConfiguration']);
                Route::get('/expiration-date', [CourseController::class, 'expirationDate']);

                Route::get('/all-dynamics-top/{id}', [CourseGameController::class, 'allDynamicsTop']);



                Route::middleware(['cors'])->group(function () {
                    Route::get('/certificate/{id}', [CertificatesController::class, 'getCertificateUser']);
                });


                Route::group(['prefix' => '/exam'], function () {
                    Route::post('/', [CourseController::class, 'exam']);
                    Route::post('/active', [Exam::class, 'getActiveExam']);
                    Route::post('/module/active', [Exam::class, 'getActiveExamModules']);
                    Route::get('/daily', [DailyQuestion::class, 'get']);
                    Route::post('/daily/points', [DailyQuestion::class, 'validateResponseDaily']);
                    Route::post('/answers', [Exam::class, 'getAnswers']);
                    Route::get('/isconfig/{id}', [CourseConfigurationController::class, 'checkIfCourseIsConfigurated']);
                    Route::post('/calification', [Exam::class, 'getCalification']);
                    Route::post('/indicators', [Exam::class, 'getIndicators']);
                    Route::get('/list', [Exam::class, 'examList']);
                });

                Route::group(['prefix' => '/game'], function () {
                    Route::post('/', [CourseGameController::class, 'game']);
                    Route::post('/active', [CourseGameController::class, 'getActiveGame']);
                    Route::post('/module/active', [CourseGameController::class, 'getActiveModuleGame']);
                    Route::post('/add-points', [CourseGameController::class, 'addPointsToUser']);
                    Route::post('/retrieve-dynamic-top', [CourseGameController::class, 'retrieveDynamicTop']);
                        Route::group(['prefix' => '/comments'], function () {
                            Route::get('/list/{id_course_game}', [CourseGameCommentController::class, 'listDynamicComments']);
                            
                            Route::post('/create', [CourseGameCommentController::class, 'createDynamicComment'])->middleware('throttle:3,1');
                        });
                });

                Route::group(['prefix' => '/dinamicas'], function () {
                    Route::get('/list/{id}', [GameController::class, 'list']);
                    Route::get('/datos/{id}', [GameController::class, 'datos']);
                });

                Route::group(['prefix' => '/certificate'], function () {
                    Route::get('/check/{id}', [CourseConfigurationController::class, 'isReadyToClaimCertificate']);
                });
                
                Route::group(['prefix' => '/congratulations'], function(){
                    Route::get('/', [CertificateController::class, 'getCongratulation']);
                });
            });

            //Api Dashboard
            Route::group(['prefix' => 'dashboard'], function () {
                Route::get('/getattributes', [PropiertiesforUserController::class, 'getPropierties']);
                Route::get('/saleshistory', [SalesController::class, 'index'])->name('api.saleshistory.index');
                Route::get('/saleshistory/{payment}', [SalesController::class, 'show'])->name('api.saleshistory.show');
                Route::get('/lastlessonseen', LessonController::class);
            });

            //Api Reports
            Route::group(['prefix' => 'reports'], function () {
                Route::get('/last-sells', [ReportsController::class, 'lastSells']);
            });

            //Api Puntos Classroom
            Route::group(['prefix' => 'classroom-points'], function () {
                Route::post('/insert-user-points', [ClassroomPointDetailController::class, 'insert']);
                Route::get('/ranking', [UserClassroomPointController::class, 'show']);
            });

            //Api Profile
            Route::group(['prefix' => 'profile'], function () {
                Route::post('/upload-photo', [UserController::class, 'uploadPhoto']);
                Route::get('/info', [UserController::class, 'myInfo']);
                Route::get('/points/{id}', [UserController::class, 'myPoints']);
                Route::post('/change-pass', [UserController::class, 'changePassword']);
            });

            Route::get('/countries', [UserController::class, 'getCountries']);

            //Api Configuracion Opciones
            Route::group(['prefix' => 'options'], function () {
                Route::get('/values', [OptionController::class, 'values']);
            });


            //Api Cart
            Route::group(['prefix' => 'cart'], function () {
                Route::post('/buy-course', [CartController::class, 'buyCourse']);
                Route::post('/buy-certificate', [CartController::class, 'buyCertificate']);
                Route::get('/show', [CartController::class, 'showCart']);
                Route::get('/add/{course}', [CartController::class, 'validateCart']);
                Route::get('/remove/{cartDetail}', [CartController::class, 'removeCart']);
                Route::get('/clear', [CartController::class, 'clearCart']);
                Route::get('/update/{action}', [CartController::class, 'payCart']);
            });

            //Api comentarios entre alumnos y productos
            Route::group(['prefix' => 'comments'], function () {
                Route::post('/send-comments', [CommentsController::class, 'sendComments']);
                Route::get('/show-comments', [CommentsController::class, 'showComments']);
            });

            //Api logros
            Route::group(['prefix' => 'badges'], function () {
                Route::get('/list', [BadgeController::class, 'getAll'])->name("all");
                Route::get('/my-badges', [BadgeController::class, 'getMyBadges'])->name('fetch-my-badges');
                Route::get('/my-progress', [BadgeController::class, 'getBadges'])->name('get-my-progress');
            });

            //Api para clases
            Route::group(['prefix' => 'class'], function () {
                Route::get('/show-class', [ModuleClassController::class, 'getDetailsClass']);
            });

            //Api para classResources
            Route::group(['prefix' => 'class-resource'], function () {
                Route::get('/show-resources', [ClassResourceController::class, 'showResources']);
                Route::get('/download-resource', [ClassResourceController::class, 'downloadResources']);
            });

            //Api para video
            Route::group(['prefix' => 'video'], function () {
                Route::get('/update-status', [VideoController::class, 'updateStatus']);
                Route::get('/stream-video', [VideoController::class, 'streamVideo']);
                Route::post('/save-time', [VideoController::class, 'saveTime']);
                Route::get('/show-time', [VideoController::class, 'showTime']);
                Route::post('/save-video', [VideoController::class, 'saveVideo']);
                Route::post('/get-video', [VideoController::class, 'getVideo']);
                Route::post('/delete-video', [VideoController::class, 'deleteVideo']);
                Route::post('/create-folder', [VideoController::class, 'createFolder']);
                Route::post('/delete-folder', [VideoController::class, 'deleteFolder']);
            });

            //Api de cursos comprados
            Route::group(['prefix' => 'purchased'], function () {
                //Route::post('/store', [PurchasedCoursesController::class, 'store']);
                Route::put('/update', [PurchasedCoursesController::class, 'update']);
                Route::get('/show', [PurchasedCoursesController::class, 'show']);
                Route::patch('/save-class-seen', [PurchasedCoursesController::class, 'saveClassSeen']);
                Route::get('/show-class-seen', [PurchasedCoursesController::class, 'showClassSeen']);
                Route::get('/completed-course', [PurchasedCoursesController::class, 'completedCourse']);
                Route::get('/certificate-data', [PurchasedCoursesController::class, 'certificateData']);
                Route::get('/get-time', [PurchasedCoursesController::class, 'getTime']);
            });


            Route::group(['prefix' => 'notifications'], function () {
                Route::get('/list', [NotificationController::class, 'myNotifications'])->name('list');
            });

            Route::group(['prefix' => 'aux'], function () {
                Route::get('/all-countries', [AuxController::class, 'allCountries']);
                Route::get('/get-states-by-country/{name_country}', [AuxController::class, 'getStatesByCountry']);
            });

            Route::group(['prefix' => '/frequent-questions'], function () {
                Route::get('/', [FrequentQuestionsController::class, 'getFrequentQuestion']);
            });


            //Api Rama Binaria
            Route::controller(RamaBinariaController::class)->prefix('ramabinaria')->group(function () {
                Route::get('/listbinary', 'listbinary');
            });

            // LIST BONNUS
            Route::controller(BonusController::class)->prefix('bonus')->group(function() {
                Route::get('/get-bonuses', 'index');
            });
        });
    }
});
