@php
$configData = Helper::applClasses();
$rol = auth()->user()->id_account_type;
$userId = auth()->user()->id;
$expiration_date = auth()->user()->expiration_date;
@endphp
<div class="main-menu menu-fixed {{($configData['theme'] === 'dark') ? 'menu-dark' : 'menu-light'}} menu-accordion menu-shadow" data-scroll-to-active="true">
    <div class="navbar-header">
        <ul class="nav navbar-nav flex-row">
            <li class="nav-item mr-auto">
                <a class="navbar-brand" href="{{url('/')}}">
                    <span class="brand-logo">
                        <img src="{{asset('images/logo/promolider_logo.png')}}" style="margin-left: 40px; min-width: 130px;width:100%">
                    </span>
                    <!-- <h2 class="brand-text">Promolider</h2> -->
                </a>
            </li>
        </ul>
    </div>
    <div></div>
    <div class="main-menu-content">
        <ul class="navigation navigation-main" id="main-menu-navigation" data-menu="menu-navigation">
            {{-- Foreach menu item starts --}}
            @if(isset($menuData[0]))
            @foreach($menuData[0]->menu as $menu)
            @if(isset($menu->navheader))
            <li class="navigation-header">
                @can($menu->slug)
                <span>{{ __('locale.'.$menu->navheader) }}</span>
                <i data-feather="more-horizontal"></i>
                @endcan
            </li>
            @else
            {{-- Add Custom Class with nav-item --}}
            @php
            $custom_classes = "";
            if(isset($menu->classlist)) {
            $custom_classes = $menu->classlist;
            }
            @endphp
            @can($menu->slug)
            <li class="nav-item {{ Route::currentRouteName() === $menu->slug ? 'active' : '' }} {{ $custom_classes }}">
                <a href="{{isset($menu->url)? url($menu->url):'javascript:void(0)'}}" class="d-flex align-items-center" target="{{isset($menu->newTab) ? '_blank':'_self'}}">
                    <i data-feather="{{ $menu->icon }}"></i>
                    <span class="menu-title text-truncate">{{ __('locale.'.$menu->name) }}</span>
                    @if (isset($menu->badge))
                    <?php $badgeClasses = "badge badge-pill badge-light-primary ml-auto mr-1" ?>
                    <span class="{{ isset($menu->badgeClass) ? $menu->badgeClass : $badgeClasses }} ">{{$menu->badge}}</span>
                    @endif
                </a>
                @if(isset($menu->submenu))
                @include('panels/submenu', ['menu' => $menu->submenu])
                @endif
            </li>
            @endcan
            @endif
            @endforeach
            @if($rol != 1 && $rol != 5 && $rol != 6)
            
            
            <div class="px-3 mt-5">
                <div id="countdown" class="btn btn-primary d-flex justify-content-center">Recomprar OPC</div>
            </div>
            @endif
            @endif
@php
            $current_date = new DateTime();


            $interval = $expiration_date->diff($current_date);

            $hours = $interval->days * 24 + $interval->h;
            if($current_date<$expiration_date){
                $debt_count=-1;
            }else{
                $debt_count=ceil($hours/720);
            }
            @endphp
            {{-- Foreach menu item ends --}}
        </ul>

    </div>

</div>
{{-- Modal para el contador regresivo--}}
<div id="modal-countdown" class="modal fade modal-primary" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <slot name="title">Expiración de OPC</slot>
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <slot name="body">
                    <p>Tiempo restante para la expiración de su estado activo</p>
                    <div class="row ml-1">
                        <div class="col-2 p-0">
                            <div class="col-12 p-0">
                                <h1 class="text-center pt-2 pb-2 bg-light" style="font-size: 300%;" id="days">0</h1>
                            </div>
                            <div class="col-12 p-0">
                                <p class="text-center">Días</p>
                            </div>
                        </div>
                        <div class="col-1 p-0">
                            <div class="col-12 p-0">
                                <h1 class="text-center pt-2 pb-2" style="font-size: 300%;">:</h1>
                            </div>
                        </div>
                        <div class="col-2 p-0">
                            <div class="col-12 p-0">
                                <h1 class="text-center pt-2 pb-2 bg-light" style="font-size: 300%;" id="hours">0</h1>
                            </div>
                            <div class="col-12 p-0">
                                <p class="text-center">Horas</p>
                            </div>
                        </div>
                        <div class="col-1 p-0">
                            <div class="col-12 p-0">
                                <h1 class="text-center pt-2 pb-2" style="font-size: 300%;">:</h1>
                            </div>
                        </div>
                        <div class="col-2 p-0">
                            <div class="col-12 p-0">
                                <h1 class="text-center pt-2 pb-2 bg-light" style="font-size: 300%;" id="minutes">0</h1>
                            </div>
                            <div class="col-12 p-0">
                                <p class="text-center">Minutos</p>
                            </div>
                        </div>
                        <div class="col-1 p-0">
                            <div class="col-12 p-0">
                                <h1 class="text-center pt-2 pb-2" style="font-size: 300%;">:</h1>
                            </div>
                        </div>
                        <div class="col-2 p-0">
                            <div class="col-12 p-0">
                                <h1 class="text-center pt-2 pb-2 bg-light" style="font-size: 300%;" id="seconds">0</h1>
                            </div>
                            <div class="col-12 p-0">
                                <p class="text-center">Segundos</p>
                            </div>
                        </div>
                    </div>
                    
                </slot>

                <form style="display:none;" id="payment_method_form" class="mt-2">
                    <div id="payment_method_selector" class="form-group col-12 col-lg-6">
                        <label for="payment_method_id">Seleccione el método de pago</label>
                        <select id="payment_method_id" name="payment_method_id" class="form-control">
                        </select>
                        <div id="payment_method_id_error" class="invalid-feedback"></div>
                    </div>

                    <div id="salto_total" class="form-group col-12 col-lg-6">
                        <p style="font-weight: bold;">Saldo Billetera: $ <span id="saldo_total_valor"></span></p>
                        <p style="font-weight: bold;">Importe Opc: $ <span id="importe_opc"></span></p>
                    </div>
                </form>
                <p id="message_conditions" style="display: none;">
                    Al hacer click en "Comprar" usted está aceptando nuestros <button type="button" class="btn btn-link" onclick="showConditions()">términos y condiciones.</button>
                </p>
            </div>
            <div class="modal-footer">@if($debt_count>0)
            <p class="font-weight-bold">Usted debe pagar <span class="text-danger">{{$debt_count}} </span>cuotas.</p>
            @endif
                <slot name="footer">
                    
                    <button class="btn btn-warning" onclick="hideForm()" id="cancel" style="display: none;">Cancelar</button>
                    <button class="btn btn-primary" onclick="payOPC()" id="continue" style="display: none;" type="button">Comprar</button>
                    <button class="btn btn-primary" onclick="showForm()" id="buy">Recompra</button>

                </slot>
            </div>
        </div>
    </div>
</div>
{{-- terminos y condiciones --}}
<div class="modal fade" id="modal_conditions" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document" style="overflow-y: initial !important">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title text-success" id="exampleModalLabel">Términos y condiciones</h5>
        </div>
        <div class="modal-body overflow-auto">
            @include('modalOpenpayConditions')
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-primary" onclick="hideConditions()" data-dismiss="modal">Cerrar</button>
        </div>
      </div>
    </div>
</div>
<!-- END: Main Menu-->
@if($rol != 1 && $rol != 5 && $rol != 6)
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    const select_payment_method = document.getElementById("payment_method_id");

    let form = document.getElementById("payment_method_form");
    let cancel_button = document.getElementById("cancel");
    let buy_button = document.getElementById("buy");
    let continue_button = document.getElementById("continue");
    let message_conditions = document.getElementById("message_conditions");
    let modal_conditions = document.getElementById("modal_conditions");
    let modal_countdown = document.getElementById("modal-countdown");
    var saldoTotalElement = document.getElementById('salto_total');
    var payment_id = '';
    var comprarButton = document.getElementById('continue');
    async function showForm() {
        const response = await fetch('/config/payment-method/list-array');
        const data = await response.json();
        const responseData = data.filter(data => !['Efectivo','Transferencia','Paypal'].includes(data.name));
        
        select_payment_method.innerHTML = "";

        responseData.forEach(function(item) {
            const optionObj = document.createElement("option");
            optionObj.textContent = item.name;
            optionObj.value = item.id;
            select_payment_method.appendChild(optionObj);
        });

        form.style.display = "block";
        cancel_button.style.display = "block";
        continue_button.style.display = "block";
        buy_button.style.display = "none";
        message_conditions.style.display = "block";
    }

    function getWallet(){
        saldoTotalElement.style.display = 'none';

        select_payment_method.addEventListener("change", function() {
            var selectVal = this.value;
            payment_id = this.value;
            if(selectVal == 5){
                getWalletUser();
                saldoTotalElement.style.display = 'block';
            }else{
                comprarButton.style.display = 'block';
                saldoTotalElement.style.display = 'none';
            }
        });
    }

    async function getWalletUser() {
        try {
            
            const userId = @json($userId);
            const response = await fetch(`/reports/mymovements/${userId}`);
            const dataRquest = await response.json();
            let saldoTotal = 0;
            let importeOpc = 51;
            dataRquest.data.forEach(transaction => {
                if(transaction.type == 1){
                    saldoTotal += transaction.amount;
                }else if(transaction.type == 0){
                    saldoTotal -= transaction.amount;
                }
            })

            const totalValor = document.getElementById('saldo_total_valor');
            const importeOpcElement = document.getElementById('importe_opc');
           

            totalValor.textContent = saldoTotal.toFixed(2);
            importeOpcElement.textContent = importeOpc;
            
            if (saldoTotal >= importeOpc && payment_id == 5) {
                comprarButton.style.display = 'block';
            } else {
                comprarButton.style.display = 'none';
            }

            return { saldoTotal, importeOpc };

        } catch (error) {
            console.error('Error al obtener la billetera del usuario:', error);
            return { saldoTotal: 0, importeOpc: 0 };
        }
    }

    async function savePaymentWallet(){
        try {
            const { saldoTotal, importeOpc } = await getWalletUser();

            const sendForm = JSON.stringify({
                saldoTotal: saldoTotal,
                importeOpc: importeOpc,
            });
            const response = await fetch('/pay/opc-wallet',{
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: sendForm
            });

            if (response.status==200) {
                Swal.fire({
                    title: "Exitoso!",
                    text: "Recompra de OPC Exitosa!",
                    icon: "success"
                });

                $('#modal-countdown').modal('hide');
                window.location.reload();
            }else{
                console.error('Error en la solicitud:', response.statusText);
            }
        } catch (error) {
            console.log('Error al registrar el pago por billetera', error)
        }
    }

    getWallet();

    function hideForm() {
        form.style.display = "none";
        continue_button.style.display = "none";
        cancel_button.style.display = "none";
        buy_button.style.display = "block";
        message_conditions.style.display = "none";
    }

    function showConditions(){
        $('#modal_conditions').modal({ show:true });
        $("#modal_conditions").addClass("overflow-auto");
        $('#modal-countdown').modal('hide')
    }

    function hideConditions(){
        $('#modal_conditions').modal('hide');
        $('#modal-countdown').modal({ show:true });
    }

    async function payOPC() {

        let value = await select_payment_method.options[select_payment_method.selectedIndex].value;

        switch (value) {
            case '1':
                window.location.href = "/pay/opc-openpay";
                break;
            case '2':

                break;
            case '3':

                break;
            case '4':
                window.location.href = "/pay/recompra";
                break;

            case '5':
                savePaymentWallet();
                break;

            default:
                break;
        }
        // direccionar de acuerdo al metodo de pago
    }

    let expiration_date = new Date();
    <?php echo "expiration_date = '$expiration_date';" ?>
    let date_target = new Date(expiration_date);
    let countdown = document.getElementById("countdown");

    countdown.addEventListener("click", function() {
        evaluateTime(date_target);
        let x = setInterval(function() {
            let distance = evaluateTime(date_target);
            if (distance < 0) {
                clearInterval(x);
            }
        }, 1000);
        $('#modal-countdown').modal('show');
        $("#modal-countdown").on('hidden.bs.modal', function() {
            clearInterval(x);
        });
    });

    function evaluateTime(date_target) {
        let now = new Date().getTime();
        let distance = date_target - now;
        let days = Math.floor(distance / (1000 * 60 * 60 * 24));
        let hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        let minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        let seconds = Math.floor((distance % (1000 * 60)) / 1000);
        days = addZero(days);
        hours = addZero(hours);
        minutes = addZero(minutes);
        seconds = addZero(seconds);

        if (distance < 0) {
            days = "00";
            hours = "00";
            minutes = "00";
            seconds = "00"
        }
        $('#days').html(days);
        $('#hours').html(hours);
        $('#minutes').html(minutes);
        $('#seconds').html(seconds);
        return distance;
    }

    function addZero(num) {
        if (num <= 9) {
            return num = "0" + num;
        } else {
            return num;
        }
    }
</script>
@endif