<?php

namespace App\Models;

use App\Helpers\ParseUrl;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Course extends Model
{
    use HasFactory;
    protected $table = 'courses';
    protected $fillable = [
        "id",
        "user_id",
        "id_categories",
        "title",
        "area",
        "description",
        "image",
        "currency",
        "price",
        "ranking_by_user",
        "status",
        "course_level_id",
        "portada",
        "url_portada",
        "price_base",
        "certificate"
    ];

    protected $casts = [
        'certificate' => 'boolean',
    ];

    public function getUrlPortadaAttribute($value)
    {
        return  ParseUrl::contacAtrrS3($value) ;
    }

    public function getPathUrlAttribute($value)
    {
        return  ParseUrl::contacAtrrS3($value) ;
    }

    public function getImageAttribute($value)
    {
        return asset('storage/images/' . $value);
    }

    public function modules(): HasMany
    {
        return $this->hasMany(Module::class, 'id_courses');
    }
    public function user(): BelongsTo
    {
        return $this->belongsTo(Module::class, 'id');
    }

}
