<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CommentDynamic extends Model
{
    use HasFactory;
    protected $table='comments_dynamic';
    protected $fillable=[
        'id_author',
        'id_course_games',
        'content'
    ];

    public function author(): BelongsTo
{
    return $this->belongsTo(User::class, 'id_author');
}

}
