<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Chat extends Model
{
    use HasFactory;

    protected $table = "chats";

    protected $fillable = [
        "title",
        "status",
        "user_id"
    ];

    public function details()
    {
        return $this->hasMany(ChatDetail::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
