<?php

namespace App\Http\Controllers\Api;

use App\Models\User;
use App\Models\Badge;
use App\Models\Point;
use App\Models\Course;
use App\Models\Option;
use App\Models\Wallet;
use App\Models\Classified;
use App\Models\AccountType;
use App\Models\BadgeDetail;
use Illuminate\Http\Request;
use App\Models\ClassroomCart;
use App\Models\Notifications;
use App\Traits\ResponseFormat;
use App\Models\PurchasedCourse;
use App\Models\UserCertificate;
use App\Models\WalletMovements;
use Illuminate\Support\Facades\DB;
use App\Models\ClassroomCartDetail;
use App\Models\CourseConfiguration;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use App\Mail\NotifyBuyCourseMailable;
use App\Http\Controllers\PayController;
use App\Http\Controllers\Api\ApiWalletMovementsController;



class CartController extends Controller
{
    use ResponseFormat;

    public function buyCourse(Request $request)
    {
        try {
            
           
            DB::beginTransaction();
            $user = auth()->user();
            $user_id = $user ? $user->id : $request->user_id;
            $courseInfo = Course::find($request->id_course);
            
            $id_producer = $courseInfo->user_id;
            $producer_data = User::find($id_producer);

            $purchase_percentage_producer= AccountType::where('id', $producer_data->id_account_type)
                ->first();

            if($request->type_purchase==2){
                $nameCourse = $courseInfo->title;
                $price_with_discount = round($courseInfo->price - ($courseInfo->price * $purchase_percentage_producer->disc_purchases_course / 100), 2);
                $user_wallet_balance=$this->retrieveWalletBalanceUser($user_id);
                if($user_wallet_balance>=$price_with_discount){
                    app(PayController::class)->saveOpcWallet($user_id,$price_with_discount,3,$nameCourse);
                }else{
                    throw new \Exception('Wallet Recharge Needed!');

                }
                // app(PayController::class)->saveOpcWallet($user_id,$bonusWallet,3,$nameCourse);
            }



            $last_batch = Option::lastBatch();
            $last_batch = (int) $last_batch->value;


            $purchased_course = new PurchasedCourse();
            $purchased_course->course_id = $request->id_course;
            $purchased_course->user_id = $user_id;

            $purchased_course->save();
            $fecha = date('d-m-Y H:i');

            $myUser = User::find($user_id);

            
            $notification = new Notifications();
            $notification->id_generator = $user_id;
            $notification->id_receiver = $courseInfo->user_id;
            $notification->title = "Nueva venta";
            $notification->body = $myUser->name .' '.$myUser->last_name.   ' acaba de comprar tu curso: '.$courseInfo->title;
            $notification->type = 2;

            $notification->save();

            $fullName = $myUser->name;
            
            //=====entrega de bono al padre por compra de curso========
            $referrer_data = User::find($myUser->id_referrer_sponsor);
            
            if($referrer_data->id > 1){//el admin no tiene referido, no se entrega bono

                $purchase_percentage_referrer = AccountType::where('id', $referrer_data->id_account_type)
                    ->first();
                
                // $type_certificate = CourseConfiguration::where('course_id', $courseInfo->id)->get()->first();
            
                // if(isset($type_certificate->type_certificate)){
                    
                //     if ($type_certificate->type_certificate == 1) {
                //         $bonus = $courseInfo->price * $purchase_percentage_referrer->course_selling_bonus / 100;
                //     } else {
                //         $discountsCertificate = round($type_certificate->data['certificate_price'] * $purchase_percentage_referrer->disc_purchases_certificates / 100, 2);
                //         $discountCourse = round($courseInfo->price * $purchase_percentage_referrer->disc_purchases_course / 100, 2);
                //         $bonus = $discountsCertificate + $discountCourse;
                //     }

                // }else{
                //     $bonus = $courseInfo->price * $purchase_percentage_referrer->course_selling_bonus / 100;
                // }

                $bonus = $courseInfo->price * $purchase_percentage_referrer->course_selling_bonus / 100;

                $wallet_referrer_data = Wallet::where('user_id', $referrer_data->id)
                    ->first();
                if ($myUser->active && $myUser->membershipActive) {
                    $wallet_referrer = new WalletMovements();
                    $wallet_referrer->wallet_id = $wallet_referrer_data->id;
                    $wallet_referrer->amount = $bonus;
                    $wallet_referrer->type = 1;
                    $wallet_referrer->batch = $last_batch;
                    $wallet_referrer->status = 1;
                    $wallet_referrer->reason = "Bono por compra de curso de ".$fullName;
                    $wallet_referrer->bonus_type_id = 2;
                    $wallet_referrer->user_purchase_id = $myUser->id;
                    $wallet_referrer->save();

                }
            }

            //========Entrega de bono al productor por compra de cursos=======
            

            
            
            $bonus = $courseInfo->price * $purchase_percentage_producer->productor_bonus / 100;
            $wallet_producer_data = Wallet::where('user_id', $producer_data->id)
                ->first();

            if ($myUser->active && $myUser->membershipActive) {
                $wallet_producer = new WalletMovements();
                $wallet_producer->wallet_id = $wallet_producer_data->id;
                $wallet_producer->amount = $bonus;
                $wallet_producer->type = 1;
                $wallet_producer->batch = $last_batch;
                $wallet_producer->status = 1;
                $wallet_producer->reason = "Bono por compra de curso de ".$fullName;
                $wallet_producer->bonus_type_id = 3;
                $wallet_producer->user_purchase_id = $myUser->id;
                $wallet_producer->save();

            }

            //=============reparto de puntos==================

            $membersip = $myUser->id_account_type;
            $fullName = $myUser->name;
            $change_currency = Option::where('description', 'currency_value')->first();
            $change_to_points = $courseInfo->price * $change_currency->value; // 1 punto -> 0.29 dolares
            $change_to_points = round($change_to_points, 0, PHP_ROUND_HALF_UP);
            $classified_user = Classified::where('user_id', $myUser->id)->first();
            $save_position_branch = $classified_user->position; //almacena la posicion del nodo anterior con respecto al actual

            $aux = false;

            if($membersip != 5 && $membersip != 6){//membresia basica y guest no genera puntos
                $tmp_id = $classified_user->user_id;
                while ($aux == false) {
                    $user_data = Classified::where('user_id', $tmp_id)->first();
                    $aux = $user_data->user_above == 'top' ? true : false;
                    $user_status = User::find($tmp_id);
                    if ($user_status->active && $user_status->qualified && $user_status->membershipActive) {
                        Point::create([
                            'user_id' => $myUser->id,
                            'sponsor_id' => $user_data->user_id,
                            'points' => $change_to_points,
                            'side' => $save_position_branch,
                            'reason' => "Course buy, " . $fullName
                        ]);
                    } elseif ($classified_user->id_user_sponsor == $user_data->user_id) {
                        Point::create([
                            'user_id' => $myUser->id,
                            'sponsor_id' => $classified_user->id_user_sponsor,
                            'points' => $change_to_points,
                            'side' => $save_position_branch,
                            'reason' => "Course buy, " . $fullName
                        ]);
                    }
                    $save_position_branch = $user_data->position;
                    $tmp_id = $user_data->user_above;
                }
            }
            
            
            $this->validateBadgeBuyCourse($user_id);
            $this->badgeSubscriberCollector($courseInfo->id, $courseInfo->user_id);//ID del productor del curso
            try{
                $this->sendNotifyBuyCourse($myUser->email, $courseInfo->title, $courseInfo->price, 
                                            $myUser->name, $fecha, $courseInfo->url_portada );
            }catch(\Exception $e){
                Log::error('Error al realizar esta operación: ' . $e->getMessage());
            }

            DB::commit();

            return $this->responseOk('saved data', $purchased_course);
        } catch(\Exception $e){
            DB::rollback();
            Log::error('La transacción falló: ' . $e->getMessage());
        }
    }


    public function retrieveWalletBalanceUser($user_id){
        $isAdmin=AccountType::find(User::find($user_id)->id_account_type)->account==='Admin';
        if(!$isAdmin){
            $allMovements=app(ApiWalletMovementsController::class)->getAllMovementsWallet($user_id);

            $result = array_reduce($allMovements->resolve(), function ($carry, $item) use($user_id){
                
                if ($item['type'] == 1) {
                    return $carry + $item['amount'];
                  } else if ($item['type'] == 0) {
                    if ($item['id_receiver']===$user_id) {
                      return $carry + $item['amount'];
                    } else {
                      return $carry - $item['amount'];
                    }
                  }
                  
                  return $carry;
}, 0);
return $result;
        }
    }



    public function buyCertificate(Request $request)
    {
        $user = auth()->user();
        $user_certificate = UserCertificate::where('id_course',$request->id_course)->where('id_user',$user->id)->get()->first();
        $user_certificate->is_paid=1;
        $user_certificate->save();
   
        $notification = new Notifications();
        $notification->id_generator = $user->id;
        $notification->id_receiver = $user->id;
        $notification->title = "Certificado comprado";
        $notification->body = 'Acaba de comprar un certificado';
        $notification->type = 2;
        $notification->save();

        $id = $user->id;
        $fullName = $user->name;
        $membersip = $user->id_account_type;

        $change_currency = Option::where('description', 'currency_value')->first();
        $course_data = CourseConfiguration::where('course_id', 1)->first();
        $price = $course_data->data['certificate_price'];
        $change_to_points = $price / $change_currency->value; // 1 punto -> 0.29 dolares
        $change_to_points = round($change_to_points, 0, PHP_ROUND_HALF_UP);
        $classified_user = Classified::where('user_id', $id)->first();
        $save_position_branch = $classified_user->position; //almacena la posicion del nodo anterior con respecto al actual

        $aux = false;

        if($membersip != 5 && $membersip != 6){//membresia basica y guest no genera puntos
            $tmp_id = $classified_user->user_id;
            while ($aux == false) {
                $user_data = Classified::where('user_id', $tmp_id)->first();
                $aux = $user_data->user_above == 'top' ? true : false;
                $user_status = User::find($tmp_id);
                if ($user_status->active && $user_status->qualified && $user_status->membershipActive) {
                    Point::create([
                        'user_id' => $user->id,
                        'sponsor_id' => $user_data->user_id,
                        'points' => $change_to_points,
                        'side' => $save_position_branch,
                        'reason' => "Certificate buy, " .$fullName
                    ]);
                } elseif ($classified_user->id_user_sponsor == $user_data->user_id) {
                    Point::create([
                        'user_id' => $user->id,
                        'sponsor_id' => $classified_user->id_user_sponsor,
                        'points' => $change_to_points,
                        'side' => $save_position_branch,
                        'reason' => "Certificate buy, " .$fullName
                    ]);
                }
                $save_position_branch = $user_data->position;
                $tmp_id = $user_data->user_above;
            }
        }

        return $this->responseOk('saved data', $user_certificate);
    }

    public function validateBadgeBuyCourse($user_id){
        // 7 .. 9 = ID LOGRO PARA EL COMPRADOR DE CURSOS       
        $purchased_courses = PurchasedCourse::where([ 'user_id' => $user_id ])->get();
        if( count($purchased_courses) > 0 ){
            $badges = Badge::select('id','name','description','level','condition','icon')
                ->where('id','>=',7)
                ->where('id','<=',9)
                ->orderBy('condition')
                ->get();
            $this->validateBadge($badges, $purchased_courses, $user_id);
        }
    }

    public function badgeSubscriberCollector($course_id, $user_id){
        //id = 16 .. 18 = ID LOGRO PARA EL COLECCIONISTA DE SUSCRIPTORES
        $purchased_courses = PurchasedCourse::where([ 'course_id' => $course_id])->get();

        if( count($purchased_courses) > 0){
            $badges = Badge::select('id','name','description','level','condition','icon')
                ->where('id','>=',16)
                ->where('id','<=',18)
                ->orderBy('condition')
                ->get();
            $this->validateBadge($badges, $purchased_courses, $user_id);
        }
    }
    
    public function validateBadge( $badges , $purchased_courses, $user_id ){

        for ($i=0; $i < count($badges) ; $i++){ 

            $badge = $badges[$i];     

            if( count( $purchased_courses ) >= $badge->condition ){
                $badges_details = BadgeDetail::select('id','user_id','badge_id')
                    ->where(['user_id'=> $user_id, 'badge_id'=> $badge->id])
                    ->get();
                
                if( count($badges_details) == 0 ){
                    $badge_detail = new BadgeDetail();
                    $badge_detail->user_id = $user_id;
                    $badge_detail->badge_id = $badge->id;

                    if( $badge_detail->save() ){
                        
                        $notification = new Notifications();
                        $notification->id_generator = 1;
                        $notification->id_receiver = $user_id;
                        $notification->id_badge = $badge->id;
                        $notification->title = "Logro desbloqueado";
                        $notification->body = "Obtuvo el logro de ".$badge->name;
                        $notification->type = 1;
                        $notification->seen= 0;
                        $notification->save();
                    }
                }
            }
            else{
                $i = count($badges);
            }
        }
    }

    /**
     * Shopping cart validator
     * @param \App\Models\Course $course {object}
     * @return addCart -> {function}
     * @return showCart -> {function}
     */

    public function validateCart(Course $course)
    {
        $courseBuy = ClassroomCart::join('classroom_cart_detail', 'classroom_cart_detail.classroom_cart_id', '=', 'classroom_cart.id')
            ->where('user_id', auth()->user()->id)->where('classroom_cart_detail.courses_id', $course->id)->count() == 0;

        $cart = ClassroomCart::CartUser()->first();
        if (!isset($cart) or $cart->status == "BOUGHT") {
            if ($courseBuy) {
                $this->createCart(auth()->user()->id);
                $cart = (ClassroomCart::CartWaiting()->first())->id;
                $this->addCart($course->id, $cart);
            }else{
                return $this->responseOk('course', 'this course has already been purchased');
            }
        } else if ($cart->status == "WAITING") {
            if ($courseBuy) {
                $this->addCart($course->id, $cart->id);
            } else {
                return $this->responseOk('course', 'this course has already been purchased');
            }
        }
        return $this->showCart();
    }

    /**
     * Create classroom cart
     * @param $user {integer} -> user's id
     */
    public function createCart($user)
    {
        $cart = new ClassroomCart();
        $cart->user_id = $user;
        $cart->save();
    }

    /**
     * Add data to ClassromCartDetail's table
     * @param $course {object}
     * @param $cart {integer} -> cart's id
     */
    public function addCart($id, $cart)
    {
        $cartDetail = new ClassroomCartDetail();
        $cartDetail->classroom_cart_id = $cart;
        $cartDetail->courses_id = $id;
        $cartDetail->save();
    }

    /**
     * Remove data to ClassroomCartDetail's table
     * @param $cartDetail {integer} -> cartDetail's id
     * @return showCart {function}
     */
    public function removeCart($cartDetail)
    {
        ClassroomCartDetail::where('id', $cartDetail)->delete();
        return $this->showCart();
    }

    /**
     * Remove data to ClasroomCartDetail's table with classroom_cart_id data
     * @param 
     * @return showCart {function}
     */
    public function clearCart()
    {
        $cart = ClassroomCart::CartWaiting()->first();
        ClassroomCartDetail::where('classroom_cart_id', $cart->id)->delete();
        return ["cart" => "Empty shopping cart"];
    }

    /**
     * Update data to ClassroomCart's table
     * @param $action {boolean} -> variable to action switch
     */
    public function payCart($action)
    {
        $cart = ClassroomCart::CartWaiting()->first();
        // switch ($action) {
        //     case 0:
        //         $cart->status = "NO ACTION";
        //         $cart->save();
        //         break;
        //     case 1:
        //         $cart->status = "BOUGHT";
        //         $cart->save();
        //         break;
        // }
        if ($cart != null) {
            $details = ClassroomCartDetail::SltData()->where('classroom_cart_id', $cart->id)->with('courses')->get();
            if (count($details) > 0) {
                if ($action == 1) {
                    $cart->status = "BOUGHT";
                    $cart->save();
                    return $this->responseOk('cart_status', 'paid');
                } else {
                    return $this->responseOk('cart_status', 'waiting');
                }
            } else {
                return ["error" => "Empty shopping cart"];
            }
        } else {
            return ["error" => "Not exists shopping cart"];
        };
    }

    /**
     * Show classroomCart's data
     * @return \Illuminate\Http\Response
     */
    public function showCart()
    {
        $cart = ClassroomCart::SltData()->CartWaiting()->first();
        if ($cart != null) {
            $details = ClassroomCartDetail::SltData()->where('classroom_cart_id', $cart->id)->with('courses')->get();
            if (count($details) > 0) {
                $cart->cart_details = $details;
                return $this->responseOk('', $cart);
            } else {
                return ["error" => "Empty shopping cart"];
            }
        } else {
            return ["error" => "Not exists shopping cart"];
        }
    }
    public function sendNotifyBuyCourse($email,$name_course,$price_course,$name_user,$date_buy,$img_course){
        
        $data = (object) array('name_course'=>$name_course,'price'=>$price_course,'name_user'=>$name_user,'date_buy'=>$date_buy
            ,'img_course'=>$img_course);

        $content = new NotifyBuyCourseMailable($data);
        Mail::to($email)
            ->cc($email)
            ->bcc($email)
            ->send($content);
    }
}
